/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.loans.CalculateLoanPaymentsAjaxForm;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class CalculateLoanPaymentsAjaxAction
extends BaseAjaxAction
implements LocalSettingsChangeListener {
    private DataBinder<ProjectionDTO> dtoBinder;
    private LoanService loanService;
    private DataBinder<Collection<LoanPayment>> paymentBinder;
    private PaymentService paymentService;
    private TransferTypeService transferTypeService;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<ProjectionDTO> getDtoBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dtoBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<ProjectionDTO> binder = BeanBinder.instance(ProjectionDTO.class);
                binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType"));
                binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
                binder.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", localSettings.getRawDateConverter()));
                binder.registerBinder("firstExpirationDate", PropertyBinder.instance(Calendar.class, "firstExpirationDate", localSettings.getRawDateConverter()));
                binder.registerBinder("paymentCount", PropertyBinder.instance(Integer.TYPE, "paymentCount"));
                this.dtoBinder = binder;
            }
            DataBinder<ProjectionDTO> dataBinder = this.dtoBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public LoanService getLoanService() {
        return this.loanService;
    }

    public PaymentService getPaymentService() {
        return this.paymentService;
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dtoBinder = null;
            this.paymentBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setLoanService(LoanService loanService) {
        this.loanService = loanService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.XML;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        try {
            CalculateLoanPaymentsAjaxForm form = (CalculateLoanPaymentsAjaxForm)((Object)context.getForm());
            ProjectionDTO dto = this.getDtoBinder().readFromString((Object)form);
            List<LoanPayment> payments = this.loanService.calculatePaymentProjection(dto);
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("payments", this.getPaymentBinder().readAsString(payments));
            this.responseHelper.writeStatus(context.getResponse(), (Object)ResponseHelper.Status.SUCCESS, values);
        }
        catch (ValidationException e) {
            this.responseHelper.writeValidationErrors(context.getResponse(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataBinder<Collection<LoanPayment>> getPaymentBinder() {
        try {
            this.lock.readLock().lock();
            if (this.paymentBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<LoanPayment> binder = BeanBinder.instance(LoanPayment.class);
                binder.registerBinder("expirationDate", PropertyBinder.instance(Calendar.class, "expirationDate", localSettings.getRawDateConverter()));
                binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
                this.paymentBinder = BeanCollectionBinder.instance(binder);
            }
            DataBinder<Collection<LoanPayment>> dataBinder = this.paymentBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

