/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.loans.ConfirmLoanForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.loangroups.LoanGroupService;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.GrantLoanDTO;
import nl.strohalm.cyclos.services.transactions.GrantLoanWithInterestDTO;
import nl.strohalm.cyclos.services.transactions.GrantMultiPaymentLoanDTO;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class ConfirmLoanAction
extends BaseFormAction {
    private LoanService loanService;
    private LoanGroupService loanGroupService;
    private TransactionFeeService transactionFeeService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private PaymentService paymentService;
    private TransferTypeService transferTypeService;
    private CustomFieldHelper customFieldHelper;

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setLoanGroupService(LoanGroupService loanGroupService) {
        this.loanGroupService = loanGroupService;
    }

    @Inject
    public void setLoanService(LoanService loanService) {
        this.loanService = loanService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        Loan loan;
        ConfirmLoanForm form = (ConfirmLoanForm)((Object)context.getForm());
        GrantLoanDTO dto = this.validateLoan(context);
        if (context.isTransactionPasswordEnabled()) {
            context.checkTransactionPassword(form.getTransactionPassword());
        }
        try {
            loan = this.loanService.grant(dto);
        }
        catch (CreditsException e) {
            return context.sendError(this.actionHelper.resolveErrorKey(e), this.actionHelper.resolveParameters(e));
        }
        catch (AuthorizedPaymentInPastException e) {
            return context.sendError("payment.error.authorizedInPast", new Object[0]);
        }
        boolean pending = loan.getTransfer().getProcessDate() == null;
        context.sendMessage(pending ? "loan.awaitingAuthorization" : "loan.granted", new Object[0]);
        if (form.getMemberId() > 0L) {
            return ActionHelper.redirectWithParam(context.getRequest(), context.findForward("member"), "memberId", form.getMemberId());
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.findForward("loanGroup"), "loanGroupId", form.getLoanGroupId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        GrantLoanDTO loan = this.validateLoan(context);
        HttpServletRequest request = context.getRequest();
        boolean requestTransactionPassword = context.isTransactionPasswordEnabled();
        if (requestTransactionPassword) {
            context.validateTransactionPassword();
        }
        request.setAttribute("requestTransactionPassword", (Object)requestTransactionPassword);
        Member member = (Member)this.elementService.load(loan.getMember().getId(), Element.Relationships.USER);
        TransferType transferType = this.transferTypeService.load(loan.getTransferType().getId(), RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY), TransferType.Relationships.TO);
        LoanGroup loanGroup = loan.getLoanGroup() == null ? null : this.loanGroupService.load(loan.getLoanGroup().getId(), LoanGroup.Relationships.MEMBERS);
        BigDecimal amount = loan.getAmount();
        loan.setLoanGroup(loanGroup);
        loan.setMember(member);
        loan.setTransferType(transferType);
        request.setAttribute("unitsPattern", (Object)transferType.getFrom().getCurrency().getPattern());
        if (loanGroup != null) {
            ArrayList<Member> membersInGroup = new ArrayList<Member>(loanGroup.getMembers());
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            Collections.sort(membersInGroup, localSettings.getMemberComparator());
            membersInGroup.remove(member);
            membersInGroup.add(0, member);
            request.setAttribute("membersInGroup", membersInGroup);
        }
        List<LoanPayment> payments = null;
        switch (loan.getLoanType()) {
            case MULTI_PAYMENT: {
                payments = ((GrantMultiPaymentLoanDTO)loan).getPayments();
                break;
            }
            case WITH_INTEREST: {
                GrantLoanWithInterestDTO dto = (GrantLoanWithInterestDTO)loan;
                ProjectionDTO projection = new ProjectionDTO();
                projection.setAmount(dto.getAmount());
                projection.setDate(dto.getDate());
                projection.setFirstExpirationDate(dto.getFirstRepaymentDate());
                projection.setTransferType(dto.getTransferType());
                projection.setPaymentCount(dto.getPaymentCount());
                payments = this.loanService.calculatePaymentProjection(projection);
            }
        }
        request.setAttribute("payments", payments);
        Collection<PaymentCustomFieldValue> customValues = loan.getCustomValues();
        if (customValues != null) {
            List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transferType, false);
            Collection<CustomFieldHelper.Entry> entries = this.customFieldHelper.buildEntries(customFields, customValues);
            for (CustomFieldHelper.Entry entry : entries) {
                Object element;
                Long memberId;
                CustomField field = entry.getField();
                CustomFieldValue fieldValue = entry.getValue();
                if (field.getType() == CustomField.Type.ENUMERATED) {
                    Long possibleValueId = CoercionHelper.coerce(Long.class, fieldValue.getValue());
                    if (possibleValueId == null) continue;
                    fieldValue.setPossibleValue(this.paymentCustomFieldService.loadPossibleValue(possibleValueId));
                    continue;
                }
                if (field.getType() != CustomField.Type.MEMBER || (memberId = CoercionHelper.coerce(Long.class, fieldValue.getValue())) == null || !((element = this.elementService.load(memberId, new Relationship[0])) instanceof Member)) continue;
                fieldValue.setMemberValue((Member)element);
            }
            request.setAttribute("customFields", entries);
        }
        TransactionFeePreviewDTO preview = this.transactionFeeService.preview(context.getAccountOwner(), member, transferType, amount);
        request.setAttribute("finalAmount", (Object)preview.getFinalAmount());
        request.setAttribute("fees", preview.getFees());
        DoPaymentDTO payment = new DoPaymentDTO();
        payment.setTransferType(loan.getTransferType());
        payment.setAmount(loan.getAmount());
        payment.setTo(member);
        request.setAttribute("wouldRequireAuthorization", (Object)this.paymentService.wouldRequireAuthorization(payment));
    }

    @Override
    protected void validateForm(ActionContext context) {
        ConfirmLoanForm form;
        if (context.isTransactionPasswordEnabled() && StringUtils.isEmpty((String)(form = (ConfirmLoanForm)((Object)context.getForm())).getTransactionPassword())) {
            throw new ValidationException("_transactionPassword", "login.transactionPassword", new RequiredError(new Object[0]));
        }
    }

    private GrantLoanDTO validateLoan(ActionContext context) {
        GrantLoanDTO payment = (GrantLoanDTO)context.getSession().getAttribute("loan");
        if (payment == null) {
            throw new ValidationException();
        }
        return payment;
    }
}

