/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.util.Calendar;
import java.util.HashMap;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.loans.DiscardLoanForm;
import nl.strohalm.cyclos.controls.loans.LoanDetailsAction;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transactions.LoanPaymentDTO;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import org.apache.struts.action.ActionForward;

public class DiscardLoanAction
extends LoanDetailsAction {
    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        DiscardLoanForm form = (DiscardLoanForm)((Object)context.getForm());
        LoanPaymentDTO dto = this.resolveLoanDTO(context);
        Loan loan = dto.getLoan();
        if (this.shouldValidateTransactionPassword(context, loan)) {
            context.checkTransactionPassword(form.getTransactionPassword());
        }
        this.loanService.discard(dto);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("loanId", form.getLoanId());
        params.put("memberId", form.getMemberId());
        params.put("loanGroupId", form.getLoanGroupId());
        context.sendMessage("loan.discarded", new Object[0]);
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void initDataBinder(BeanBinder<? extends LoanPaymentDTO> binder) {
        super.initDataBinder(binder);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        binder.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", localSettings.getRawDateConverter()));
    }
}

