/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.loans.SearchLoanPaymentsAction;
import nl.strohalm.cyclos.controls.loans.SearchLoanPaymentsForm;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPaymentQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.conversion.CustomFieldConverter;
import nl.strohalm.cyclos.utils.conversion.MessageConverter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class ExportLoanPaymentsToCsvAction
extends BaseCsvAction {
    private DataBinder<LoanPaymentQuery> dataBinder;
    private LoanService loanService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<LoanPaymentQuery> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                this.dataBinder = SearchLoanPaymentsAction.loanPaymentQueryDataBinder(this.settingsService.getLocalSettings());
            }
            DataBinder<LoanPaymentQuery> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public LoanService getLoanService() {
        return this.loanService;
    }

    public PaymentCustomFieldService getPaymentCustomFieldService() {
        return this.paymentCustomFieldService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            super.onLocalSettingsUpdate(event);
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setLoanService(LoanService loanService) {
        this.loanService = loanService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    protected List<?> executeQuery(ActionContext context) {
        SearchLoanPaymentsForm form = (SearchLoanPaymentsForm)((Object)context.getForm());
        LoanPaymentQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.fetch(RelationshipHelper.nested(LoanPayment.Relationships.LOAN, Loan.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER, Element.Relationships.USER));
        return this.loanService.search(query);
    }

    @Override
    protected String fileName(ActionContext context) {
        Object loggedUser = context.getUser();
        return "loan_payments_" + ((User)loggedUser).getUsername() + ".csv";
    }

    protected CSVWriter resolveCSVWriter(ActionContext context) {
        SearchLoanPaymentsForm form = (SearchLoanPaymentsForm)((Object)context.getForm());
        LoanPaymentQuery query = this.getDataBinder().readFromString(form.getQuery());
        LocalSettings settings = this.settingsService.getLocalSettings();
        CSVWriter<LoanPayment> csv = CSVWriter.instance(LoanPayment.class, settings);
        TransferType transferType = query.getTransferType();
        if (transferType != null) {
            List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transferType, true);
            for (PaymentCustomField field : customFields) {
                csv.addColumn(field.getName(), "loan.transfer.customValues", new CustomFieldConverter(field, this.elementService, settings));
            }
        }
        csv.addColumn(context.message("member.username", new Object[0]), "loan.transfer.to.member.username");
        csv.addColumn(context.message("loanPayment.expirationDate", new Object[0]), "expirationDate", settings.getRawDateConverter());
        csv.addColumn(context.message("loanPayment.repaymentDate", new Object[0]), "repaymentDate", settings.getDateTimeConverter());
        csv.addColumn(context.message("loanPayment.amount", new Object[0]), "amount", settings.getNumberConverter());
        csv.addColumn(context.message("loanPayment.status", new Object[0]), "status", new MessageConverter(context, "loanPayment.status."));
        csv.addColumn(context.message("loanPayment.search.repaidAmount", new Object[0]), "repaidAmount", settings.getNumberConverter());
        csv.addColumn(context.message("loanPayment.search.discardedAmount", new Object[0]), "discardedAmount", settings.getNumberConverter());
        return csv;
    }
}

