/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.loans.SearchLoansAction;
import nl.strohalm.cyclos.controls.loans.SearchLoansForm;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.conversion.CollectionCountConverter;
import nl.strohalm.cyclos.utils.conversion.CustomFieldConverter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class ExportLoansToCsvAction
extends BaseCsvAction {
    private DataBinder<LoanQuery> dataBinder;
    private LoanService loanService;
    private PaymentCustomFieldService paymentCustomFieldService;

    public DataBinder<LoanQuery> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = SearchLoansAction.loanQueryDataBinder(this.settingsService.getLocalSettings());
        }
        return this.dataBinder;
    }

    public LoanService getLoanService() {
        return this.loanService;
    }

    public PaymentCustomFieldService getPaymentCustomFieldService() {
        return this.paymentCustomFieldService;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setLoanService(LoanService loanService) {
        this.loanService = loanService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    protected List<?> executeQuery(ActionContext context) {
        SearchLoansForm form = (SearchLoansForm)((Object)context.getForm());
        LoanQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.fetch(Loan.Relationships.PAYMENTS, RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.TYPE), RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.CUSTOM_VALUES), RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER, Element.Relationships.USER));
        return this.loanService.search(query);
    }

    @Override
    protected String fileName(ActionContext context) {
        Object loggedUser = context.getUser();
        return "loans_" + ((User)loggedUser).getUsername() + ".csv";
    }

    protected CSVWriter resolveCSVWriter(ActionContext context) {
        LocalSettings settings = this.settingsService.getLocalSettings();
        CSVWriter<Loan> csv = CSVWriter.instance(Loan.class, settings);
        SearchLoansForm form = (SearchLoansForm)((Object)context.getForm());
        LoanQuery query = this.getDataBinder().readFromString(form.getQuery());
        TransferType transferType = query.getTransferType();
        csv.addColumn(context.message("loan.grantDate", new Object[0]), "transfer.date", settings.getDateTimeConverter());
        csv.addColumn(context.message("loan.amount", new Object[0]), "transfer.amount", settings.getNumberConverter());
        csv.addColumn(context.message("loan.type", new Object[0]), "transfer.type.name");
        csv.addColumn(context.message("member.username", new Object[0]), "transfer.to.member.username");
        csv.addColumn(context.message("member.member", new Object[0]), "transfer.to.member.name");
        csv.addColumn(context.message("loan.description", new Object[0]), "transfer.description");
        csv.addColumn(context.message("loan.totalAmount", new Object[0]), "totalAmount", settings.getNumberConverter());
        csv.addColumn(context.message("loan.remainingAmount", new Object[0]), "remainingAmount", settings.getNumberConverter());
        csv.addColumn(context.message("loan.firstOpenPayment", new Object[0]), "firstOpenPayment.index");
        csv.addColumn(context.message("loan.paymentCount", new Object[0]), "payments", CollectionCountConverter.instance());
        csv.addColumn(context.message("loan.expirationDate", new Object[0]), "expirationDate", settings.getRawDateConverter());
        csv.addColumn(context.message("loan.repaymentDate", new Object[0]), "repaymentDate", settings.getDateConverter());
        if (transferType != null) {
            List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transferType, true);
            for (PaymentCustomField field : customFields) {
                csv.addColumn(field.getName(), "transfer.customValues", new CustomFieldConverter(field, this.elementService, settings));
            }
        }
        return csv;
    }
}

