/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.loans.GrantLoanForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroupQuery;
import nl.strohalm.cyclos.entities.accounts.loans.LoanParameters;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.loangroups.LoanGroupService;
import nl.strohalm.cyclos.services.transactions.GrantLoanDTO;
import nl.strohalm.cyclos.services.transactions.GrantLoanWithInterestDTO;
import nl.strohalm.cyclos.services.transactions.GrantMultiPaymentLoanDTO;
import nl.strohalm.cyclos.services.transactions.GrantSinglePaymentLoanDTO;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts.action.ActionForward;

public class GrantLoanAction
extends BaseFormAction {
    private LoanGroupService loanGroupService;
    private LoanService loanService;
    private TransferTypeService transferTypeService;

    @Inject
    public void setLoanGroupService(LoanGroupService loanGroupService) {
        this.loanGroupService = loanGroupService;
    }

    @Inject
    public void setLoanService(LoanService loanService) {
        this.loanService = loanService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        GrantLoanForm form = (GrantLoanForm)((Object)context.getForm());
        Member member = null;
        LoanGroup loanGroup = null;
        if (form.getMemberId() > 0L) {
            Object element = this.elementService.load(form.getMemberId(), Element.Relationships.USER);
            if (element instanceof Member) {
                member = (Member)element;
            }
        } else if (form.getLoanGroupId() > 0L) {
            loanGroup = this.loanGroupService.load(form.getLoanGroupId(), LoanGroup.Relationships.MEMBERS);
        }
        if (member == null && loanGroup == null) {
            throw new ValidationException();
        }
        request.setAttribute("member", member);
        request.setAttribute("loanGroup", loanGroup);
        if (member != null) {
            List<Object> transferTypes;
            form.setLoan("member", member.getId());
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.VIEW_INFORMATION_OF, Group.Relationships.TRANSFER_TYPES);
            ArrayList<SystemAccountType> systemAccounts = new ArrayList<SystemAccountType>(adminGroup.getViewInformationOf());
            if (CollectionUtils.isEmpty(systemAccounts)) {
                transferTypes = Collections.emptyList();
            } else {
                TransferTypeQuery ttQuery = new TransferTypeQuery();
                ttQuery.setContext(TransactionContext.LOAN);
                ttQuery.setToOwner(member);
                ttQuery.setUsePriority(true);
                ttQuery.setFromAccountTypes(systemAccounts);
                transferTypes = this.transferTypeService.search(ttQuery);
                Collection<TransferType> transferTypesWithPermission = adminGroup.getTransferTypes();
                Iterator<Object> iter = transferTypes.iterator();
                while (iter.hasNext()) {
                    TransferType transferType = (TransferType)iter.next();
                    if (transferTypesWithPermission.contains(transferType)) continue;
                    iter.remove();
                }
            }
            if (transferTypes.isEmpty()) {
                return context.sendError("loan.error.noTransferType", new Object[0]);
            }
            request.setAttribute("transferTypes", transferTypes);
            if (this.permissionService.hasPermission(AdminMemberPermission.LOAN_GROUPS_VIEW)) {
                LoanGroupQuery lgQuery = new LoanGroupQuery();
                lgQuery.setMember(member);
                List<LoanGroup> loanGroups = this.loanGroupService.search(lgQuery);
                request.setAttribute("loanGroups", loanGroups);
            }
        } else {
            form.setLoan("loanGroup", loanGroup.getId());
        }
        return context.getInputForward();
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        GrantLoanDTO dto = this.resolveDTO(context);
        GrantLoanForm form = (GrantLoanForm)((Object)context.getForm());
        context.getSession().setAttribute("loan", (Object)dto);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("memberId", form.getMemberId());
        params.put("loanGroupId", form.getLoanGroupId());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void validateForm(ActionContext context) {
        GrantLoanDTO dto = this.resolveDTO(context);
        this.loanService.validate(dto);
    }

    private DataBinder<GrantLoanDTO> getDataBinder(Loan.Type type) {
        LocalSettings settings = this.settingsService.getLocalSettings();
        BeanBinder<PaymentCustomFieldValue> customValueBinder = BeanBinder.instance(PaymentCustomFieldValue.class);
        customValueBinder.registerBinder("field", PropertyBinder.instance(PaymentCustomField.class, "field", ReferenceConverter.instance(PaymentCustomField.class)));
        customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
        BeanBinder<GrantLoanDTO> binder = new BeanBinder<GrantLoanDTO>();
        binder.registerBinder("member", PropertyBinder.instance(Member.class, "member", ReferenceConverter.instance(Member.class)));
        binder.registerBinder("loanGroup", PropertyBinder.instance(LoanGroup.class, "loanGroup", ReferenceConverter.instance(LoanGroup.class)));
        binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", settings.getNumberConverter()));
        binder.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", settings.getRawDateConverter()));
        binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
        binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType", ReferenceConverter.instance(TransferType.class)));
        binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
        switch (type) {
            case SINGLE_PAYMENT: {
                binder.setType(GrantSinglePaymentLoanDTO.class);
                binder.registerBinder("repaymentDate", PropertyBinder.instance(Calendar.class, "repaymentDate", settings.getRawDateConverter()));
                break;
            }
            case MULTI_PAYMENT: {
                binder.setType(GrantMultiPaymentLoanDTO.class);
                BeanBinder<LoanPayment> paymentBinder = BeanBinder.instance(LoanPayment.class);
                paymentBinder.registerBinder("expirationDate", PropertyBinder.instance(Calendar.class, "expirationDate", settings.getRawDateConverter()));
                paymentBinder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", settings.getNumberConverter()));
                binder.registerBinder("payments", BeanCollectionBinder.instance(paymentBinder, "payments"));
                break;
            }
            case WITH_INTEREST: {
                binder.setType(GrantLoanWithInterestDTO.class);
                binder.registerBinder("firstRepaymentDate", PropertyBinder.instance(Calendar.class, "firstRepaymentDate", settings.getRawDateConverter()));
                binder.registerBinder("paymentCount", PropertyBinder.instance(Integer.TYPE, "paymentCount"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid loan type: " + type);
            }
        }
        return binder;
    }

    private GrantLoanDTO resolveDTO(ActionContext context) {
        GrantLoanForm form = (GrantLoanForm)((Object)context.getForm());
        long transferTypeId = CoercionHelper.coerce(Long.TYPE, form.getLoan("transferType"));
        if (transferTypeId <= 0L) {
            throw new ValidationException();
        }
        TransferType transferType = this.transferTypeService.load(transferTypeId, RelationshipHelper.nested(TransferType.Relationships.TO, AccountType.Relationships.CURRENCY));
        LoanParameters loanParameters = transferType.getLoan();
        if (loanParameters == null || loanParameters.getType() == null) {
            throw new ValidationException("transferType", "transfer.type", new InvalidError());
        }
        GrantLoanDTO dto = this.getDataBinder(loanParameters.getType()).readFromString(form.getLoan());
        dto.setTransferType(transferType);
        if (dto.getLoanGroup() != null && !this.permissionService.hasPermission(AdminMemberPermission.LOAN_GROUPS_VIEW)) {
            throw new PermissionDeniedException();
        }
        return dto;
    }
}

