/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.loans.BaseLoanActionForm;
import nl.strohalm.cyclos.controls.loans.LoanDetailsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanParameters;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.loans.LoanRepaymentAmountsDTO;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.LoanPaymentDTO;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class LoanDetailsAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    protected LoanService loanService;
    protected PaymentService paymentService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private DataBinder<? extends LoanPaymentDTO> dataBinder;
    private CustomFieldHelper customFieldHelper;

    public DataBinder<? extends LoanPaymentDTO> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<? extends LoanPaymentDTO> binder = BeanBinder.instance(this.getDtoClass());
            this.initDataBinder(binder);
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setLoanService(LoanService loanService) {
        this.loanService = loanService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    protected Class<? extends LoanPaymentDTO> getDtoClass() {
        return LoanPaymentDTO.class;
    }

    protected void initDataBinder(BeanBinder<? extends LoanPaymentDTO> binder) {
        binder.registerBinder("loan", PropertyBinder.instance(Loan.class, "loanId"));
        binder.registerBinder("loanPayment", PropertyBinder.instance(LoanPayment.class, "loanPaymentId"));
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        LoanPaymentDTO loanDTO = this.resolveLoanDTO(context);
        Loan loan = loanDTO.getLoan();
        LoanPayment firstOpenPayment = loan.getFirstOpenPayment();
        boolean closed = loan.getStatus().isClosed();
        String currencyPattern = loan.getTransferType().getCurrency().getPattern();
        request.setAttribute("loan", (Object)loan);
        request.setAttribute("showRelatedTransfer", (Object)this.paymentService.isVisible(loan.getTransfer()));
        request.setAttribute("currencyPattern", (Object)currencyPattern);
        if (loan.getParameters().getType() == Loan.Type.WITH_INTEREST) {
            LoanParameters params = loan.getParameters();
            if (params.getMonthlyInterestAmount() != null) {
                request.setAttribute("monthlyInterestPattern", (Object)(params.getMonthlyInterestAmount().getType() == Amount.Type.FIXED ? currencyPattern : ""));
            }
            if (params.getExpirationDailyInterestAmount() != null) {
                request.setAttribute("expirationDailyInterestPattern", (Object)(params.getExpirationDailyInterestAmount().getType() == Amount.Type.FIXED ? currencyPattern : ""));
            }
            if (params.getExpirationFee() != null) {
                request.setAttribute("expirationFeePattern", (Object)(params.getExpirationFee().getType() == Amount.Type.FIXED ? currencyPattern : ""));
            }
            if (params.getGrantFee() != null) {
                request.setAttribute("grantFeePattern", (Object)(params.getGrantFee().getType() == Amount.Type.FIXED ? currencyPattern : ""));
            }
        }
        Member member = (Member)this.elementService.load(loan.getMember().getId(), Element.Relationships.GROUP);
        Transfer transfer = loan.getTransfer();
        List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transfer.getType(), true);
        Collection<CustomFieldHelper.Entry> entries = this.customFieldHelper.buildEntries(customFields, transfer.getCustomValues());
        request.setAttribute("customFields", entries);
        if (CollectionUtils.isNotEmpty(loan.getToMembers())) {
            ArrayList<Member> membersInGroup = new ArrayList<Member>(loan.getToMembers());
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            Collections.sort(membersInGroup, localSettings.getMemberComparator());
            membersInGroup.remove(member);
            membersInGroup.add(0, member);
            request.setAttribute("membersInLoan", membersInGroup);
        }
        boolean canRepay = false;
        boolean canDiscard = false;
        boolean canMarkAsInProcess = false;
        boolean canMarkAsUnrecoverable = false;
        boolean canMarkAsRecovered = false;
        if (!closed && transfer.getProcessDate() != null) {
            LoanPayment.Status firstOpenPaymentStatus = firstOpenPayment.getStatus();
            if (firstOpenPaymentStatus == LoanPayment.Status.IN_PROCESS) {
                if (this.permissionService.hasPermission(AdminMemberPermission.LOANS_MANAGE_EXPIRED_STATUS)) {
                    canMarkAsRecovered = true;
                    canMarkAsUnrecoverable = true;
                }
            } else if (context.isMember()) {
                Member loggedElement = (Member)context.getElement();
                boolean repayByGroup = loggedElement.getMemberGroup().getMemberSettings().isRepayLoanByGroup();
                if (loggedElement.equals(member) || repayByGroup && loan.getToMembers().contains(loggedElement)) {
                    canRepay = this.permissionService.hasPermission(MemberPermission.LOANS_REPAY);
                }
            } else if (context.isOperator()) {
                Operator operator = (Operator)context.getElement();
                if (operator.getMember().equals(member)) {
                    canRepay = this.permissionService.hasPermission(OperatorPermission.LOANS_REPAY);
                }
            } else if (context.isAdmin()) {
                boolean isThroughMember = ((LoanDetailsForm)((Object)context.getForm())).getMemberId() > 0L;
                boolean isTheResponsible = ((LoanDetailsForm)((Object)context.getForm())).getMemberId() == loan.getMember().getId().longValue();
                canRepay = this.permissionService.hasPermission(AdminMemberPermission.LOANS_REPAY) && (!isThroughMember || isThroughMember && isTheResponsible);
                canDiscard = this.permissionService.hasPermission(AdminMemberPermission.LOANS_DISCARD);
                canMarkAsInProcess = firstOpenPaymentStatus == LoanPayment.Status.EXPIRED && this.permissionService.hasPermission(AdminMemberPermission.LOANS_MANAGE_EXPIRED_STATUS);
            }
        }
        boolean canPerformExpiredAction = canMarkAsInProcess || canMarkAsUnrecoverable || canMarkAsRecovered;
        request.setAttribute("canRepay", (Object)canRepay);
        request.setAttribute("canDiscard", (Object)canDiscard);
        request.setAttribute("canMarkAsInProcess", (Object)canMarkAsInProcess);
        request.setAttribute("canMarkAsRecovered", (Object)canMarkAsRecovered);
        request.setAttribute("canMarkAsUnrecoverable", (Object)canMarkAsUnrecoverable);
        request.setAttribute("canPerformExpiredAction", (Object)canPerformExpiredAction);
        if (canRepay || canDiscard || canPerformExpiredAction) {
            boolean allowPartialRepayments = transfer.getType().getLoan().getType().allowsPartialRepayments();
            request.setAttribute("allowPartialRepayments", (Object)allowPartialRepayments);
            LoanRepaymentAmountsDTO dto = this.loanService.getLoanPaymentAmount(loanDTO);
            request.setAttribute("repaymentAmounts", (Object)dto);
            boolean requestTransactionPassword = this.shouldValidateTransactionPassword(context, loan);
            if (requestTransactionPassword) {
                context.validateTransactionPassword();
            }
            request.setAttribute("requestTransactionPassword", (Object)requestTransactionPassword);
        }
        if (canRepay) {
            TransferType repaymentType = loan.getTransfer().getType().getLoan().getRepaymentType();
            request.setAttribute("repaymentTransferTypeId", (Object)repaymentType.getId());
        }
    }

    protected LoanPaymentDTO resolveLoanDTO(ActionContext context) {
        LoanDetailsForm form = (LoanDetailsForm)((Object)context.getForm());
        LoanPaymentDTO dto = this.getDataBinder().readFromString((Object)form);
        Loan loan = dto.getLoan();
        if (loan == null) {
            throw new ValidationException();
        }
        Relationship[] relationships = new Relationship[]{RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.CUSTOM_VALUES), RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.TYPE), RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER, Element.Relationships.USER), Loan.Relationships.PAYMENTS, RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.CUSTOM_VALUES), Loan.Relationships.LOAN_GROUP, Loan.Relationships.TO_MEMBERS};
        loan = this.loanService.load(loan.getId(), relationships);
        dto.setLoan(loan);
        return dto;
    }

    protected boolean shouldValidateTransactionPassword(ActionContext context, Loan loan) {
        if (context.getAccountOwner().equals(loan.getMember())) {
            return context.isTransactionPasswordEnabled(loan.getTransferType().getTo());
        }
        return context.isTransactionPasswordEnabled();
    }

    @Override
    protected void validateForm(ActionContext context) {
        BaseLoanActionForm form;
        LoanPaymentDTO loanDTO = this.resolveLoanDTO(context);
        if (this.shouldValidateTransactionPassword(context, loanDTO.getLoan()) && StringUtils.isEmpty((String)(form = (BaseLoanActionForm)((Object)context.getForm())).getTransactionPassword())) {
            throw new ValidationException("_transactionPassword", "login.transactionPassword", new RequiredError(new Object[0]));
        }
    }
}

