/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.util.HashMap;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.loans.LoanDetailsAction;
import nl.strohalm.cyclos.controls.loans.ManageExpiredStatusForm;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ManageExpiredStatusAction
extends LoanDetailsAction {
    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        LoanPayment.Status status;
        ManageExpiredStatusForm form = (ManageExpiredStatusForm)((Object)context.getForm());
        try {
            status = LoanPayment.Status.valueOf(form.getStatus());
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        Loan loan = this.resolveLoanDTO(context).getLoan();
        if (this.shouldValidateTransactionPassword(context, loan)) {
            context.checkTransactionPassword(form.getTransactionPassword());
        }
        switch (status) {
            case IN_PROCESS: {
                this.loanService.markAsInProcess(loan);
                break;
            }
            case RECOVERED: {
                this.loanService.markAsRecovered(loan);
                break;
            }
            case UNRECOVERABLE: {
                this.loanService.markAsUnrecoverable(loan);
                break;
            }
            default: {
                throw new ValidationException();
            }
        }
        String statusMsg = context.message("loan.status." + status.name(), new Object[0]);
        context.sendMessage("loan.changedExpiredStatus", statusMsg);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("loanId", form.getLoanId());
        params.put("memberId", form.getMemberId());
        params.put("loanGroupId", form.getLoanGroupId());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }
}

