/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.loans.SearchLoanPaymentsAction;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPaymentQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PrintLoanPaymentsAction
extends SearchLoanPaymentsAction {
    @Override
    protected Integer pageSize(ActionContext context) {
        return null;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        String statusLabel;
        TransferType transferType;
        HttpServletRequest request = context.getRequest();
        LoanPaymentQuery query = (LoanPaymentQuery)super.prepareForm(context);
        query.fetch(RelationshipHelper.nested(LoanPayment.Relationships.LOAN, Loan.Relationships.TRANSFER, Payment.Relationships.CUSTOM_VALUES));
        if (query.getTransferType() != null) {
            query.setTransferType(this.transferTypeService.load(query.getTransferType().getId(), new Relationship[0]));
        }
        if (query.getLoanGroup() != null) {
            query.setLoanGroup(this.loanGroupService.load(query.getLoanGroup().getId(), new Relationship[0]));
        }
        if ((transferType = query.getTransferType()) != null) {
            List<PaymentCustomField> allFields = this.paymentCustomFieldService.list(transferType, true);
            ArrayList<PaymentCustomField> customFieldsForList = new ArrayList<PaymentCustomField>();
            for (PaymentCustomField customField : allFields) {
                if (customField.getListAccess() == PaymentCustomField.Access.NONE) continue;
                customFieldsForList.add(customField);
            }
            request.setAttribute("loanCustomFields", customFieldsForList);
        }
        request.setAttribute("paymentsToReceive", (Object)this.buildSummary(query, LoanPayment.Status.OPEN, LoanPayment.Status.EXPIRED));
        request.setAttribute("discardedPayments", (Object)this.buildSummary(query, LoanPayment.Status.DISCARDED));
        request.setAttribute("receivedPayments", (Object)this.buildSummary(query, LoanPayment.Status.REPAID));
        request.setAttribute("inProcessPayments", (Object)this.buildSummary(query, LoanPayment.Status.IN_PROCESS));
        request.setAttribute("unrecoverablePayments", (Object)this.buildSummary(query, LoanPayment.Status.UNRECOVERABLE));
        request.setAttribute("recoveredPayments", (Object)this.buildSummary(query, LoanPayment.Status.RECOVERED));
        List<LoanPayment.Status> status = query.getStatusList();
        if (CollectionUtils.isEmpty(status) || status.size() == LoanPayment.Status.values().length) {
            statusLabel = context.message("global.search.all.male", new Object[0]);
        } else {
            ArrayList<String> labels = new ArrayList<String>(status.size());
            for (LoanPayment.Status current : status) {
                labels.add(context.message("loanPayment.status." + current, new Object[0]));
            }
            statusLabel = StringUtils.join(labels.iterator(), (String)", ");
        }
        request.setAttribute("statusLabel", (Object)statusLabel);
        return query;
    }

    private TransactionSummaryVO buildSummary(LoanPaymentQuery query, LoanPayment.Status ... requiredStatus) {
        List<LoanPayment.Status> usedStatus;
        List<LoanPayment.Status> selectedStatus = query.getStatusList();
        if (CollectionUtils.isEmpty(selectedStatus)) {
            usedStatus = Arrays.asList(requiredStatus);
        } else {
            usedStatus = new ArrayList<LoanPayment.Status>();
            for (LoanPayment.Status current : requiredStatus) {
                if (!selectedStatus.contains(current)) continue;
                usedStatus.add(current);
            }
        }
        if (usedStatus.isEmpty()) {
            return new TransactionSummaryVO(0, BigDecimal.ZERO);
        }
        LoanPaymentQuery newQuery = (LoanPaymentQuery)query.clone();
        newQuery.clearFetch();
        newQuery.setStatusList(usedStatus);
        return this.loanService.paymentsSummary(newQuery);
    }
}

