/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.loans.LoanDetailsAction;
import nl.strohalm.cyclos.controls.loans.RepayLoanForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transactions.LoanPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.RepayLoanDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.PartialInterestsAmountException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class RepayLoanAction
extends LoanDetailsAction {
    private static final Relationship FETCH = RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.TYPE, TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY);
    private PaymentService paymentService;

    public PaymentService getPaymentService() {
        return this.paymentService;
    }

    @Override
    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Override
    protected Class<? extends LoanPaymentDTO> getDtoClass() {
        return RepayLoanDTO.class;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        RepayLoanForm form = (RepayLoanForm)((Object)context.getForm());
        RepayLoanDTO dto = (RepayLoanDTO)this.resolveLoanDTO(context);
        Loan loan = dto.getLoan();
        if (this.shouldValidateTransactionPassword(context, loan)) {
            context.checkTransactionPassword(form.getTransactionPassword());
        }
        try {
            this.loanService.repay(dto);
        }
        catch (NotEnoughCreditsException e) {
            return context.sendError("loan.repayment.error.enoughCredits", new Object[0]);
        }
        catch (UpperCreditLimitReachedException e) {
            return context.sendError("loan.repayment.error.upperCreditLimit", new Object[0]);
        }
        catch (PartialInterestsAmountException e) {
            AccountType accountType = loan.getTransfer().getType().getTo();
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            UnitsConverter nc = localSettings.getUnitsConverter(accountType.getCurrency().getPattern());
            BigDecimal baseRemainingAmount = e.getBaseRemainingAmount();
            BigDecimal totalRemainingAmount = baseRemainingAmount.add(e.getInterestsAmount());
            return context.sendError("loan.repayment.error.partialInterestsAmount", nc.toString(baseRemainingAmount), nc.toString(totalRemainingAmount));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("loanId", form.getLoanId());
        params.put("memberId", form.getMemberId());
        params.put("loanGroupId", form.getLoanGroupId());
        context.sendMessage("loan.repaid", new Object[0]);
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected ActionForward handleValidation(ActionContext context) {
        try {
            AccountType accountType;
            super.validateForm(context);
            RepayLoanDTO dto = (RepayLoanDTO)this.resolveLoanDTO(context);
            Loan loan = dto.getLoan();
            BigDecimal amount = dto.getAmount();
            ValidationException val = new ValidationException();
            val.setPropertyKey("amount", "loan.repayment.amount");
            if (loan == null) {
                val.addPropertyError("loan", new RequiredError(new Object[0]));
            }
            if (amount == null || amount.compareTo(this.paymentService.getMinimumPayment()) == -1) {
                val.addPropertyError("amount", new RequiredError(new Object[0]));
            }
            val.throwIfHasErrors();
            loan = this.loanService.load(loan.getId(), FETCH);
            try {
                accountType = loan.getTransfer().getType().getLoan().getRepaymentType().getFrom();
            }
            catch (Exception e) {
                throw new UnexpectedEntityException("Unable to retrieve loan account type");
            }
            LocalSettings settings = this.settingsService.getLocalSettings();
            UnitsConverter unitsConverter = settings.getUnitsConverter(accountType.getCurrency().getPattern());
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("confirmationMessage", context.message("loan.repayment.confirmationMessage", unitsConverter.toString(amount)));
            this.responseHelper.writeStatus(context.getResponse(), (Object)ResponseHelper.Status.SUCCESS, fields);
        }
        catch (ValidationException e) {
            this.responseHelper.writeValidationErrors(context.getResponse(), e);
        }
        return null;
    }

    @Override
    protected void initDataBinder(BeanBinder<? extends LoanPaymentDTO> binder) {
        super.initDataBinder(binder);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        BeanBinder<PaymentCustomFieldValue> customValueBinder = BeanBinder.instance(PaymentCustomFieldValue.class);
        binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
        binder.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", localSettings.getRawDateConverter()));
        customValueBinder.registerBinder("field", PropertyBinder.instance(PaymentCustomField.class, "field"));
        customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
        binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
    }
}

