/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.loans.SearchLoanPaymentsForm;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroupQuery;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPaymentQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.loangroups.LoanGroupService;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.MapBean;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchLoanPaymentsAction
extends BaseQueryAction {
    protected PaymentCustomFieldService paymentCustomFieldService;
    protected MemberCustomFieldService memberCustomFieldService;
    protected LoanService loanService;
    protected TransferTypeService transferTypeService;
    protected LoanGroupService loanGroupService;
    private DataBinder<LoanPaymentQuery> dataBinder;
    private CustomFieldHelper customFieldHelper;

    public static DataBinder<LoanPaymentQuery> loanPaymentQueryDataBinder(LocalSettings localSettings) {
        BeanBinder<MemberCustomFieldValue> memberCustomValueBinder = BeanBinder.instance(MemberCustomFieldValue.class);
        memberCustomValueBinder.registerBinder("field", PropertyBinder.instance(MemberCustomField.class, "field", ReferenceConverter.instance(MemberCustomField.class)));
        memberCustomValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
        BeanBinder<PaymentCustomFieldValue> loanCustomValueBinder = BeanBinder.instance(PaymentCustomFieldValue.class);
        loanCustomValueBinder.registerBinder("field", PropertyBinder.instance(PaymentCustomField.class, "field", ReferenceConverter.instance(PaymentCustomField.class)));
        loanCustomValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
        BeanBinder<LoanPaymentQuery> binder = BeanBinder.instance(LoanPaymentQuery.class);
        binder.registerBinder("statusList", SimpleCollectionBinder.instance(LoanPayment.Status.class, "statusList"));
        binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType"));
        binder.registerBinder("member", PropertyBinder.instance(Member.class, "member", ReferenceConverter.instance(Member.class)));
        binder.registerBinder("broker", PropertyBinder.instance(Member.class, "broker", ReferenceConverter.instance(Member.class)));
        binder.registerBinder("loanGroup", PropertyBinder.instance(LoanGroup.class, "loanGroup", ReferenceConverter.instance(LoanGroup.class)));
        binder.registerBinder("memberCustomValues", BeanCollectionBinder.instance(memberCustomValueBinder, "memberValues"));
        binder.registerBinder("loanCustomValues", BeanCollectionBinder.instance(loanCustomValueBinder, "loanValues"));
        binder.registerBinder("expirationPeriod", DataBinderHelper.periodBinder(localSettings, "expirationPeriod"));
        binder.registerBinder("repaymentPeriod", DataBinderHelper.periodBinder(localSettings, "repaymentPeriod"));
        binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
        return binder;
    }

    public DataBinder<LoanPaymentQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            this.dataBinder = SearchLoanPaymentsAction.loanPaymentQueryDataBinder(settings);
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public final void setLoanGroupService(LoanGroupService loanGroupService) {
        this.loanGroupService = loanGroupService;
    }

    @Inject
    public final void setLoanService(LoanService loanService) {
        this.loanService = loanService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public final void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        SearchLoanPaymentsForm form = (SearchLoanPaymentsForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        LoanPaymentQuery query = (LoanPaymentQuery)queryParameters;
        List<LoanPayment> loanPayments = this.loanService.search(query);
        request.setAttribute("loanPayments", loanPayments);
        form.setQueryAlreadyExecuted(true);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        SearchLoanPaymentsForm form = (SearchLoanPaymentsForm)((Object)context.getForm());
        LoanPaymentQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.fetch(RelationshipHelper.nested(LoanPayment.Relationships.LOAN, Loan.Relationships.TRANSFER, Payment.Relationships.CUSTOM_VALUES), RelationshipHelper.nested(LoanPayment.Relationships.LOAN, Loan.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER, Element.Relationships.USER));
        AdminGroup adminGroup = (AdminGroup)context.getGroup();
        adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
        query.setGroups(adminGroup.getManagesGroups());
        TransferTypeQuery ttQuery = new TransferTypeQuery();
        ttQuery.setContext(TransactionContext.LOAN);
        ttQuery.setToGroups(adminGroup.getManagesGroups());
        List<TransferType> transferTypes = this.transferTypeService.search(ttQuery);
        if (transferTypes.size() == 1) {
            query.setTransferType(transferTypes.iterator().next());
            request.setAttribute("singleTransferType", (Object)query.getTransferType());
        }
        request.setAttribute("transferTypes", transferTypes);
        List<MemberCustomField> memberFields = this.customFieldHelper.onlyForLoanSearch(this.memberCustomFieldService.list());
        request.setAttribute("memberFieldValues", this.customFieldHelper.buildEntries(memberFields, query.getMemberCustomValues()));
        TransferType transferType = query.getTransferType();
        form.setQuery("loanValues", new MapBean(true, "field", "value"));
        if (transferType == null) {
            query.setLoanCustomValues(null);
        } else {
            List<PaymentCustomField> allFields = this.paymentCustomFieldService.list(transferType, true);
            request.setAttribute("allFields", allFields);
            ArrayList<PaymentCustomField> customFieldsForSearch = new ArrayList<PaymentCustomField>();
            ArrayList<PaymentCustomField> customFieldsForList = new ArrayList<PaymentCustomField>();
            for (PaymentCustomField customField : allFields) {
                if (customField.getSearchAccess() != PaymentCustomField.Access.NONE) {
                    customFieldsForSearch.add(customField);
                }
                if (customField.getListAccess() == PaymentCustomField.Access.NONE) continue;
                customFieldsForList.add(customField);
            }
            request.setAttribute("customFieldsForList", customFieldsForList);
            Collection<PaymentCustomFieldValue> loanCustomValues = query.getLoanCustomValues();
            if (loanCustomValues != null) {
                Iterator<PaymentCustomFieldValue> iterator = loanCustomValues.iterator();
                while (iterator.hasNext()) {
                    PaymentCustomFieldValue fieldValue = iterator.next();
                    if (customFieldsForSearch.contains(fieldValue.getField())) continue;
                    iterator.remove();
                }
            }
            request.setAttribute("loanFieldValues", this.customFieldHelper.buildEntries(customFieldsForSearch, loanCustomValues));
        }
        RequestHelper.storeEnum(request, LoanPayment.Status.class, "status");
        if (this.permissionService.hasPermission(AdminSystemPermission.LOAN_GROUPS_VIEW)) {
            LoanGroupQuery lgQuery = new LoanGroupQuery();
            request.setAttribute("loanGroups", this.loanGroupService.search(lgQuery));
        } else {
            request.setAttribute("loanGroups", Collections.emptyList());
        }
        if (query.getMember() != null) {
            query.setMember((Member)this.elementService.load(query.getMember().getId(), Element.Relationships.USER));
        }
        if (query.getBroker() != null) {
            query.setBroker((Member)this.elementService.load(query.getBroker().getId(), Element.Relationships.USER));
        }
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        SearchLoanPaymentsForm form = (SearchLoanPaymentsForm)((Object)context.getForm());
        if (form.isQueryAlreadyExecuted()) {
            return true;
        }
        return super.willExecuteQuery(context, queryParameters);
    }
}

