/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.loans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.loans.SearchLoansForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroupQuery;
import nl.strohalm.cyclos.entities.accounts.loans.LoanQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.loangroups.LoanGroupService;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.MapBean;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class SearchLoansAction
extends BaseQueryAction {
    private PaymentCustomFieldService paymentCustomFieldService;
    private MemberCustomFieldService memberCustomFieldService;
    private DataBinder<LoanQuery> dataBinder;
    private LoanGroupService loanGroupService;
    private LoanService loanService;
    private TransferTypeService transferTypeService;
    private CustomFieldHelper customFieldHelper;

    public static DataBinder<LoanQuery> loanQueryDataBinder(LocalSettings localSettings) {
        BeanBinder<MemberCustomFieldValue> memberCustomValueBinder = BeanBinder.instance(MemberCustomFieldValue.class);
        memberCustomValueBinder.registerBinder("field", PropertyBinder.instance(MemberCustomField.class, "field", ReferenceConverter.instance(MemberCustomField.class)));
        memberCustomValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
        BeanBinder<PaymentCustomFieldValue> loanCustomValueBinder = BeanBinder.instance(PaymentCustomFieldValue.class);
        loanCustomValueBinder.registerBinder("field", PropertyBinder.instance(PaymentCustomField.class, "field", ReferenceConverter.instance(PaymentCustomField.class)));
        loanCustomValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
        BeanBinder<LoanQuery> binder = BeanBinder.instance(LoanQuery.class);
        binder.registerBinder("status", PropertyBinder.instance(Loan.Status.class, "status"));
        binder.registerBinder("queryStatus", PropertyBinder.instance(LoanQuery.QueryStatus.class, "queryStatus"));
        binder.registerBinder("transferStatus", PropertyBinder.instance(Payment.Status.class, "transferStatus"));
        binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType"));
        binder.registerBinder("member", PropertyBinder.instance(Member.class, "member", ReferenceConverter.instance(Member.class)));
        binder.registerBinder("broker", PropertyBinder.instance(Member.class, "broker", ReferenceConverter.instance(Member.class)));
        binder.registerBinder("loanGroup", PropertyBinder.instance(LoanGroup.class, "loanGroup", ReferenceConverter.instance(LoanGroup.class)));
        binder.registerBinder("memberCustomValues", BeanCollectionBinder.instance(memberCustomValueBinder, "memberValues"));
        binder.registerBinder("loanCustomValues", BeanCollectionBinder.instance(loanCustomValueBinder, "loanValues"));
        binder.registerBinder("grantPeriod", DataBinderHelper.periodBinder(localSettings, "grantPeriod"));
        binder.registerBinder("expirationPeriod", DataBinderHelper.periodBinder(localSettings, "expirationPeriod"));
        binder.registerBinder("paymentPeriod", DataBinderHelper.periodBinder(localSettings, "paymentPeriod"));
        binder.registerBinder("transactionNumber", PropertyBinder.instance(String.class, "transactionNumber"));
        binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
        return binder;
    }

    public DataBinder<LoanQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            this.dataBinder = SearchLoansAction.loanQueryDataBinder(localSettings);
        }
        return this.dataBinder;
    }

    public LoanGroupService getLoanGroupService() {
        return this.loanGroupService;
    }

    public LoanService getLoanService() {
        return this.loanService;
    }

    public PaymentCustomFieldService getPaymentCustomFieldService() {
        return this.paymentCustomFieldService;
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setLoanGroupService(LoanGroupService loanGroupService) {
        this.loanGroupService = loanGroupService;
    }

    @Inject
    public void setLoanService(LoanService loanService) {
        this.loanService = loanService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    protected boolean computeMultiPayment() {
        return true;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        SearchLoansForm form = (SearchLoansForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        LoanQuery query = (LoanQuery)queryParameters;
        List<Loan> loans = this.loanService.search(query);
        boolean isMultiPayment = false;
        if (this.computeMultiPayment()) {
            for (Loan loan : loans) {
                if (loan.getParameters().getType() == Loan.Type.SINGLE_PAYMENT) continue;
                isMultiPayment = true;
                break;
            }
        }
        request.setAttribute("loans", loans);
        request.setAttribute("isMultiPayment", (Object)isMultiPayment);
        form.setQueryAlreadyExecuted(true);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        SearchLoansForm form = (SearchLoansForm)((Object)context.getForm());
        long memberId = form.getMemberId();
        long loanGroupId = form.getLoanGroupId();
        boolean fullQuery = context.isAdmin() && memberId == 0L && loanGroupId == 0L;
        boolean myLoans = false;
        boolean byBroker = false;
        request.setAttribute("fullQuery", (Object)fullQuery);
        if (RequestHelper.isGet(request) && !form.isQueryAlreadyExecuted()) {
            if (fullQuery) {
                form.setQuery("queryStatus", LoanQuery.QueryStatus.OPEN.name());
            } else {
                form.setQuery("status", Loan.Status.OPEN.name());
            }
        }
        LoanQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.fetch(Loan.Relationships.PAYMENTS, RelationshipHelper.nested(Loan.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER, Element.Relationships.USER));
        Member member = null;
        if (context.isAdmin()) {
            if (memberId > 0L) {
                Object element = this.elementService.load(memberId, Element.Relationships.USER);
                if (!(element instanceof Member)) {
                    throw new ValidationException();
                }
                member = (Member)element;
            } else {
                member = query.getMember();
            }
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
            query.setGroups(adminGroup.getManagesGroups());
        } else {
            Member loggedMember = (Member)context.getAccountOwner();
            if (memberId == 0L || memberId == loggedMember.getId()) {
                member = loggedMember;
                myLoans = true;
            } else {
                Object element = this.elementService.load(memberId, Element.Relationships.USER);
                if (!(element instanceof Member)) {
                    throw new ValidationException();
                }
                member = (Member)element;
                if (!context.isBrokerOf(member)) {
                    throw new ValidationException();
                }
                byBroker = true;
            }
        }
        query.setMember(member);
        request.setAttribute("member", (Object)member);
        request.setAttribute("myLoans", (Object)myLoans);
        request.setAttribute("byBroker", (Object)byBroker);
        if (context.isAdmin()) {
            RequestHelper.storeEnum(request, Loan.Status.class, "status");
        } else {
            request.setAttribute("status", EnumSet.of(Loan.Status.OPEN, Loan.Status.CLOSED));
        }
        EnumSet<LoanQuery.QueryStatus> queryStatus = EnumSet.allOf(LoanQuery.QueryStatus.class);
        if (!this.permissionService.hasPermission(AdminMemberPermission.LOANS_VIEW_AUTHORIZED)) {
            Iterator it = queryStatus.iterator();
            while (it.hasNext()) {
                if (!((LoanQuery.QueryStatus)((Object)it.next())).isAuthorizationRelated()) continue;
                it.remove();
            }
        }
        request.setAttribute("queryStatus", queryStatus);
        LoanGroup loanGroup = null;
        if (loanGroupId > 0L) {
            loanGroup = this.loanGroupService.load(loanGroupId, new Relationship[0]);
            query.setLoanGroup(loanGroup);
        }
        request.setAttribute("loanGroup", loanGroup);
        if (fullQuery) {
            List<TransferType> transferTypes;
            TransferTypeQuery ttQuery = new TransferTypeQuery();
            ttQuery.setContext(TransactionContext.LOAN);
            if (context.isAdmin()) {
                AdminGroup adminGroup = (AdminGroup)context.getGroup();
                adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
                ttQuery.setToGroups(adminGroup.getManagesGroups());
            }
            if ((transferTypes = this.transferTypeService.search(ttQuery)).size() == 1) {
                query.setTransferType(transferTypes.iterator().next());
                request.setAttribute("singleTransferType", (Object)query.getTransferType());
            }
            request.setAttribute("transferTypes", transferTypes);
            List<MemberCustomField> memberFields = this.customFieldHelper.onlyForLoanSearch(this.memberCustomFieldService.list());
            request.setAttribute("memberFieldValues", this.customFieldHelper.buildEntries(memberFields, query.getMemberCustomValues()));
            TransferType transferType = query.getTransferType();
            form.setQuery("loanValues", new MapBean(true, "field", "value"));
            if (transferType == null) {
                query.setLoanCustomValues(null);
            } else {
                List<PaymentCustomField> allFields = this.paymentCustomFieldService.list(transferType, true);
                request.setAttribute("allFields", allFields);
                ArrayList<PaymentCustomField> customFieldsForSearch = new ArrayList<PaymentCustomField>();
                ArrayList<PaymentCustomField> customFieldsForList = new ArrayList<PaymentCustomField>();
                for (PaymentCustomField customField : allFields) {
                    if (customField.getSearchAccess() != PaymentCustomField.Access.NONE) {
                        customFieldsForSearch.add(customField);
                    }
                    if (customField.getListAccess() == PaymentCustomField.Access.NONE) continue;
                    customFieldsForList.add(customField);
                }
                request.setAttribute("customFieldsForList", customFieldsForList);
                Collection<PaymentCustomFieldValue> loanCustomValues = query.getLoanCustomValues();
                if (loanCustomValues != null) {
                    Iterator<PaymentCustomFieldValue> iterator = loanCustomValues.iterator();
                    while (iterator.hasNext()) {
                        PaymentCustomFieldValue fieldValue = iterator.next();
                        if (customFieldsForSearch.contains(fieldValue.getField())) continue;
                        iterator.remove();
                    }
                }
                request.setAttribute("loanFieldValues", this.customFieldHelper.buildEntries(customFieldsForSearch, loanCustomValues));
            }
            if (this.permissionService.hasPermission(AdminSystemPermission.LOAN_GROUPS_VIEW)) {
                LoanGroupQuery lgQuery = new LoanGroupQuery();
                request.setAttribute("loanGroups", this.loanGroupService.search(lgQuery));
            } else {
                request.setAttribute("loanGroups", Collections.emptyList());
            }
            if (query.getMember() != null) {
                query.setMember((Member)this.elementService.load(query.getMember().getId(), Element.Relationships.USER));
            }
            if (query.getBroker() != null) {
                query.setBroker((Member)this.elementService.load(query.getBroker().getId(), Element.Relationships.USER));
            }
        }
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        SearchLoansForm form = (SearchLoansForm)((Object)context.getForm());
        if (form.isQueryAlreadyExecuted()) {
            return true;
        }
        HttpServletRequest request = context.getRequest();
        boolean fullQuery = (Boolean)request.getAttribute("fullQuery");
        return !fullQuery || RequestHelper.isPost(request);
    }
}

