/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.controls.BasePublicFormAction;
import nl.strohalm.cyclos.controls.members.AcceptRegistrationAgreementForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.members.RegisteredMember;
import nl.strohalm.cyclos.entities.members.RegistrationAgreement;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.LoginHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AcceptRegistrationAgreementAction
extends BasePublicFormAction {
    @Override
    protected ActionForward handleDisplay(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RegisteredMember registeredMember = this.findRegisteredMember(actionForm, request);
        RegistrationAgreement registrationAgreement = this.findAgreement(registeredMember);
        if (registrationAgreement == null) {
            throw new ValidationException();
        }
        request.setAttribute("registeredMember", (Object)registeredMember);
        request.setAttribute("registrationAgreement", (Object)registrationAgreement);
        return mapping.getInputForward();
    }

    @Override
    protected ActionForward handleSubmit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RegisteredMember registeredMember = this.findRegisteredMember(actionForm, request);
        request.getSession().removeAttribute("shallAcceptRegistrationAgreement");
        if (registeredMember instanceof PendingMember) {
            PendingMember pendingMember = (PendingMember)registeredMember;
            try {
                this.elementService.setRegistrationAgreementAgreed(pendingMember);
            }
            catch (DaoException e) {
                String validationKeyMessage = this.messageHelper.message("pendingMember.validationKey", new Object[0]);
                return ActionHelper.sendError(mapping, request, response, "errors.invalid", validationKeyMessage);
            }
            return ActionHelper.redirectWithParam(request, mapping.findForward("validateRegistration"), "key", pendingMember.getValidationKey());
        }
        this.elementService.acceptAgreement(request.getRemoteAddr());
        return mapping.findForward("login");
    }

    private RegistrationAgreement findAgreement(RegisteredMember registeredMember) {
        MemberGroup group = (MemberGroup)this.groupService.load(registeredMember.getMemberGroup().getId(), MemberGroup.Relationships.REGISTRATION_AGREEMENT);
        return group.getRegistrationAgreement();
    }

    private RegisteredMember findRegisteredMember(ActionForm actionForm, HttpServletRequest request) {
        Entity registeredMember = null;
        User loggedUser = LoginHelper.getLoggedUser(request);
        if (loggedUser == null) {
            AcceptRegistrationAgreementForm form = (AcceptRegistrationAgreementForm)actionForm;
            try {
                String validationKey = form.getKey();
                registeredMember = this.elementService.loadPendingMemberByKey(validationKey, new Relationship[0]);
            }
            catch (Exception e) {}
        } else if (loggedUser instanceof MemberUser) {
            registeredMember = ((MemberUser)loggedUser).getMember();
        }
        if (registeredMember == null) {
            throw new ValidationException();
        }
        return registeredMember;
    }
}

