/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.elements.ChangeElementGroupAction;
import nl.strohalm.cyclos.controls.members.ChangeMemberGroupForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.elements.MemberService;
import nl.strohalm.cyclos.services.elements.exceptions.ChangeMemberGroupException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ChangeMemberGroupAction
extends ChangeElementGroupAction {
    private MemberService memberService;

    public MemberService getMemberService() {
        return this.memberService;
    }

    @Inject
    public void setMemberService(MemberService memberService) {
        this.memberService = memberService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        try {
            ChangeMemberGroupForm form = (ChangeMemberGroupForm)((Object)context.getForm());
            ActionForward forward = ActionHelper.redirectWithParam(context.getRequest(), super.handleSubmit(context), "memberId", form.getMemberId());
            String key = "changeGroup.member.changed";
            if (CurrentTransactionData.hasMailError()) {
                key = key + ".mailError";
            }
            context.sendMessage(key, new Object[0]);
            return forward;
        }
        catch (ChangeMemberGroupException e) {
            return context.sendError(e.getErrorKey(), e.getErrorArgument());
        }
    }

    @Override
    protected ActionForward handleValidation(ActionContext context) {
        try {
            this.validateForm(context);
            ChangeMemberGroupForm form = (ChangeMemberGroupForm)((Object)context.getForm());
            Object newGroup = this.groupService.load(form.getNewGroupId(), new Relationship[0]);
            if (((Group)newGroup).getStatus() == Group.Status.REMOVED) {
                HashMap<String, String> fields = new HashMap<String, String>();
                fields.put("confirmationMessage", context.message("changeGroup.confirmRemove", ((Group)newGroup).getName()));
                this.responseHelper.writeStatus(context.getResponse(), (Object)ResponseHelper.Status.SUCCESS, fields);
            } else {
                this.responseHelper.writeValidationSuccess(context.getResponse());
            }
        }
        catch (ValidationException e) {
            this.responseHelper.writeValidationErrors(context.getResponse(), e);
        }
        return null;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        super.prepareForm(context);
        HttpServletRequest request = context.getRequest();
        Member member = (Member)request.getAttribute("element");
        boolean isActive = member.getActivationDate() != null;
        request.setAttribute("canRemove", (Object)(!isActive && member.getGroup().getStatus().isEnabled() ? 1 : 0));
        request.setAttribute("member", (Object)member);
    }
}

