/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.elements.CreateElementAction;
import nl.strohalm.cyclos.controls.elements.CreateElementForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.RegisteredMember;
import nl.strohalm.cyclos.exceptions.MailSendingException;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.elements.WhenSaving;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class CreateMemberAction
extends CreateElementAction<Member> {
    private MemberCustomFieldService memberCustomFieldService;
    private CustomFieldHelper customFieldHelper;

    @Override
    public DataBinder<? extends Element> getDataBinder() {
        if (this.dataBinder == null) {
            DataBinder<Element> binder = this.getBaseBinder();
            ((BeanBinder)binder).registerBinder("broker", PropertyBinder.instance(Member.class, "broker"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public MemberCustomFieldService getMemberCustomFieldService() {
        return this.memberCustomFieldService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Override
    protected ActionForward create(Element element, ActionContext context) {
        Long paramValue;
        ActionForward forward;
        String paramName;
        RegisteredMember registeredMember;
        User user;
        boolean allowSetPassword;
        CreateElementForm form = (CreateElementForm)((Object)context.getForm());
        Member member = (Member)element;
        this.ensureBrokerIsSet(context, element);
        boolean sendPasswordByEmail = member.getMemberGroup().getMemberSettings().isSendPasswordByEmail();
        boolean canChangePassword = this.permissionService.hasPermission((Permission)((Object)(context.isAdmin() ? AdminMemberPermission.ACCESS_CHANGE_PASSWORD : BrokerPermission.MEMBER_ACCESS_CHANGE_PASSWORD)));
        boolean bl = allowSetPassword = !sendPasswordByEmail || canChangePassword;
        if (!allowSetPassword && (user = member.getUser()) != null) {
            user.setPassword(null);
        }
        if (!sendPasswordByEmail && !canChangePassword) {
            form.setForceChangePassword(true);
        }
        String successKey = "createMember.created";
        try {
            registeredMember = (RegisteredMember)this.elementService.register(member, form.isForceChangePassword(), context.getRequest().getRemoteAddr());
        }
        catch (MailSendingException e) {
            return context.sendError("createMember.error.mailSending", new Object[0]);
        }
        boolean sendMessage = false;
        if (CurrentTransactionData.hasMailError()) {
            successKey = "createMember.created.mailError";
            sendMessage = true;
        }
        if (form.isOpenProfile()) {
            if (registeredMember instanceof Member) {
                paramName = "memberId";
                forward = context.findForward("profile");
                paramValue = registeredMember.getId();
            } else if (this.permissionService.permission().admin(AdminMemberPermission.MEMBERS_MANAGE_PENDING).broker(BrokerPermission.MEMBERS_MANAGE_PENDING).hasPermission()) {
                paramName = "pendingMemberId";
                forward = context.findForward("pendingMemberProfile");
                paramValue = registeredMember.getId();
            } else {
                successKey = "createMember.created.pending";
                sendMessage = true;
                paramName = "groupId";
                paramValue = registeredMember.getMemberGroup().getId();
                forward = context.findForward("new");
            }
        } else {
            sendMessage = true;
            paramName = "groupId";
            paramValue = registeredMember.getMemberGroup().getId();
            forward = context.findForward("new");
        }
        if (sendMessage) {
            context.sendMessage(successKey, new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), forward, paramName, paramValue);
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        super.formAction(context);
        context.sendMessage("createMember.created", new Object[0]);
    }

    @Override
    protected Class<MemberCustomField> getCustomFieldClass() {
        return MemberCustomField.class;
    }

    @Override
    protected Class<MemberCustomFieldValue> getCustomFieldValueClass() {
        return MemberCustomFieldValue.class;
    }

    @Override
    protected Class<Member> getElementClass() {
        return Member.class;
    }

    @Override
    protected Class<MemberGroup> getGroupClass() {
        return MemberGroup.class;
    }

    @Override
    protected Class<MemberUser> getUserClass() {
        return MemberUser.class;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        CreateElementForm form = (CreateElementForm)((Object)context.getForm());
        if (form.getGroupId() <= 0L) {
            throw new ValidationException();
        }
        MemberGroup group = (MemberGroup)this.groupService.load(form.getGroupId(), new Relationship[0]);
        List<MemberCustomField> customFields = this.customFieldHelper.onlyForGroup(this.memberCustomFieldService.list(), group);
        boolean byBroker = context.isBroker();
        Iterator<MemberCustomField> iterator = customFields.iterator();
        while (iterator.hasNext()) {
            MemberCustomField field = iterator.next();
            if (field.getUpdateAccess().granted((Group)context.getGroup(), false, byBroker, true, false)) continue;
            iterator.remove();
        }
        request.setAttribute("customFields", customFields);
        request.setAttribute("group", (Object)group);
        boolean sendPasswordByEmail = group.getMemberSettings().isSendPasswordByEmail();
        boolean canChangePassword = this.permissionService.hasPermission((Permission)((Object)(context.isAdmin() ? AdminMemberPermission.ACCESS_CHANGE_PASSWORD : BrokerPermission.MEMBER_ACCESS_CHANGE_PASSWORD)));
        request.setAttribute("allowAutomaticPassword", (Object)(sendPasswordByEmail && canChangePassword ? 1 : 0));
        request.setAttribute("allowSetPassword", (Object)(!sendPasswordByEmail || canChangePassword ? 1 : 0));
        request.setAttribute("allowSetForceChangePassword", (Object)canChangePassword);
        if (context.isAdmin()) {
            GroupQuery query = new GroupQuery();
            query.setNatures(Group.Nature.BROKER);
            query.setStatus(Group.Status.NORMAL);
            query.setPageForCount();
            boolean allowSetBroker = PageHelper.getTotalCount(this.groupService.search(query)) > 0;
            request.setAttribute("allowSetBroker", (Object)allowSetBroker);
        } else if (context.isBroker()) {
            request.setAttribute("byBroker", (Object)true);
        } else {
            throw new ValidationException();
        }
    }

    @Override
    protected void runValidation(ActionContext context, Element element) {
        CreateElementForm form = (CreateElementForm)((Object)context.getForm());
        boolean manualPassword = form.isManualPassword();
        WhenSaving when = context.isAdmin() ? WhenSaving.MEMBER_BY_ADMIN : WhenSaving.BY_BROKER;
        this.ensureBrokerIsSet(context, element);
        this.elementService.validate(element, when, manualPassword);
    }

    private void ensureBrokerIsSet(ActionContext context, Element element) {
        if (context.isBroker()) {
            Member member = (Member)element;
            member.setBroker((Member)context.getElement());
        }
    }
}

