/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.elements.ExportElementsToCsvAction;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.members.FullTextElementQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.conversion.CustomFieldConverter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;

public class ExportMembersToCsvAction
extends ExportElementsToCsvAction {
    private MemberCustomFieldService memberCustomFieldService;

    public MemberCustomFieldService getMemberCustomFieldService() {
        return this.memberCustomFieldService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Override
    protected String fileName(ActionContext context) {
        Object loggedUser = context.getUser();
        return "members_" + ((User)loggedUser).getUsername() + ".csv";
    }

    protected CSVWriter resolveCSVWriter(ActionContext context) {
        LocalSettings settings = this.settingsService.getLocalSettings();
        CSVWriter<Member> csv = CSVWriter.instance(Member.class, settings);
        csv.addColumn(context.message("member.id", new Object[0]), "id");
        csv.addColumn(context.message("member.username", new Object[0]), "user.username");
        csv.addColumn(context.message("member.name", new Object[0]), "name");
        csv.addColumn(context.message("member.email", new Object[0]), "email");
        csv.addColumn(context.message("member.creationDate", new Object[0]), "creationDate", settings.getDateConverter());
        csv.addColumn(context.message("member.activationDate", new Object[0]), "activationDate", settings.getDateConverter());
        csv.addColumn(context.message("member.lastLogin", new Object[0]), "user.lastLogin", settings.getDateTimeConverter());
        csv.addColumn(context.message("member.loanGroups", new Object[0]), "loanGroups", new LoanGroupsConverter());
        csv.addColumn(context.message("member.group", new Object[0]), "group.name");
        List customFields = this.memberCustomFieldService.list();
        for (MemberCustomField field : customFields) {
            csv.addColumn(field.getName(), "customValues", new CustomFieldConverter(field, this.elementService, settings));
        }
        csv.addColumn(context.message("member.brokerUsername", new Object[0]), "broker.username");
        csv.addColumn(context.message("member.brokerName", new Object[0]), "broker.name");
        return csv;
    }

    @Override
    protected FullTextElementQuery resolveQuery(ActionContext context) {
        FullTextElementQuery query = super.resolveQuery(context);
        query.fetch(Member.Relationships.CUSTOM_VALUES, Member.Relationships.LOAN_GROUPS, Member.Relationships.BROKER);
        return query;
    }

    static class LoanGroupsConverter
    implements Converter<Collection<LoanGroup>> {
        private static final long serialVersionUID = 5416771410900971276L;

        LoanGroupsConverter() {
        }

        @Override
        public String toString(Collection<LoanGroup> loanGroups) {
            StringBuilder builder = new StringBuilder();
            int loanGroupsCount = 0;
            for (LoanGroup group : loanGroups) {
                if (loanGroupsCount != 0) {
                    builder.append(", ");
                }
                builder.append(group.getName());
                ++loanGroupsCount;
            }
            return builder.toString();
        }

        @Override
        public Collection<LoanGroup> valueOf(String string) {
            return null;
        }
    }
}

