/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.members.LoadMemberAjaxForm;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;

public class LoadMemberAjaxAction
extends BaseAjaxAction {
    private ChannelService channelService;

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        Member member;
        LoadMemberAjaxForm form = (LoadMemberAjaxForm)((Object)context.getForm());
        PrincipalType principalType = this.channelService.resolvePrincipalType(form.getChannel(), form.getPrincipalType());
        String principal = form.getPrincipal();
        try {
            member = this.elementService.loadByPrincipal(principalType, principal, Element.Relationships.USER);
        }
        catch (EntityNotFoundException e) {
            member = null;
        }
        String json = DataBinderHelper.simpleElementBinder().readAsString(member);
        this.responseHelper.writeJSON(context.getResponse(), json);
    }
}

