/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.elements.ProfileAction;
import nl.strohalm.cyclos.controls.members.MemberProfileForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.images.OwneredImage;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupFilterQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.PendingEmailChange;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.exceptions.MailSendingException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.customization.ImageService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.elements.MemberRecordService;
import nl.strohalm.cyclos.services.elements.ReferenceService;
import nl.strohalm.cyclos.services.elements.WhenSaving;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.ImageHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;

public class MemberProfileAction
extends ProfileAction<Member> {
    private static final Relationship[] FETCH = new Relationship[]{RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP), RelationshipHelper.nested(User.Relationships.ELEMENT, Member.Relationships.BROKER), RelationshipHelper.nested(User.Relationships.ELEMENT, Member.Relationships.CUSTOM_VALUES)};
    private AccountService accountService;
    private MemberCustomFieldService memberCustomFieldService;
    private GroupFilterService groupFilterService;
    private ImageService imageService;
    private MemberRecordService memberRecordService;
    private ReferenceService referenceService;
    private CustomFieldHelper customFieldHelper;

    @Inject
    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Inject
    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Inject
    public void setMemberRecordService(MemberRecordService memberRecordService) {
        this.memberRecordService = memberRecordService;
    }

    @Inject
    public void setReferenceService(ReferenceService referenceService) {
        this.referenceService = referenceService;
    }

    @Override
    protected <CFV extends CustomFieldValue> Class<CFV> getCustomFieldValueClass() {
        return MemberCustomFieldValue.class;
    }

    @Override
    protected Class<Member> getElementClass() {
        return Member.class;
    }

    @Override
    protected <G extends Group> Class<G> getGroupClass() {
        return MemberGroup.class;
    }

    @Override
    protected <U extends User> Class<U> getUserClass() {
        return MemberUser.class;
    }

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        boolean removed;
        SystemGroup group;
        MemberProfileForm form = (MemberProfileForm)((Object)context.getForm());
        boolean profileOfBrokered = false;
        boolean myProfile = false;
        boolean profileOfOtherMember = false;
        boolean operatorCanViewReports = false;
        MemberUser memberUser = null;
        HttpServletRequest request = context.getRequest();
        Object loggedElement = context.getElement();
        if (form.getMemberId() > 0L && form.getMemberId() != ((Entity)loggedElement).getId().longValue()) {
            Object loaded = this.elementService.loadUser(form.getMemberId(), FETCH);
            if (loaded instanceof MemberUser) {
                memberUser = (MemberUser)loaded;
                profileOfOtherMember = true;
            }
            if (context.isAdmin()) {
                try {
                    request.setAttribute("isLoggedIn", (Object)this.accessService.isLoggedIn(memberUser));
                }
                catch (NotConnectedException e) {
                    // empty catch block
                }
            }
            if (context.isOperator()) {
                Operator operator = (Operator)context.getElement();
                if (!memberUser.getMember().equals(operator.getMember())) {
                    operatorCanViewReports = this.permissionService.hasPermission(MemberPermission.REPORTS_VIEW);
                }
            }
        }
        if (memberUser == null && context.isMember()) {
            memberUser = (MemberUser)this.elementService.loadUser(((Entity)context.getUser()).getId(), FETCH);
            myProfile = true;
        }
        if (memberUser == null) {
            throw new ValidationException();
        }
        Member member = memberUser.getMember();
        if (!((Entity)loggedElement).equals(member) && (loggedElement instanceof Administrator ? !((AdminGroup)(group = (AdminGroup)this.groupService.load(((Entity)context.getGroup()).getId(), AdminGroup.Relationships.MANAGES_GROUPS))).getManagesGroups().contains(member.getGroup()) : !((MemberGroup)(group = (MemberGroup)this.groupService.load(((Member)context.getAccountOwner()).getGroup().getId(), MemberGroup.Relationships.CAN_VIEW_PROFILE_OF_GROUPS))).getCanViewProfileOfGroups().contains(member.getGroup()) && !context.isBrokerOf(member))) {
            throw new PermissionDeniedException();
        }
        boolean memberCanAccessExternalChannels = false;
        MemberGroup group2 = (MemberGroup)this.groupService.load(member.getMemberGroup().getId(), MemberGroup.Relationships.CHANNELS);
        for (Channel current : group2.getChannels()) {
            if ("web".equals(current.getInternalName())) continue;
            memberCanAccessExternalChannels = true;
        }
        request.setAttribute("memberCanAccessExternalChannels", (Object)memberCanAccessExternalChannels);
        Collection<Reference.Nature> referenceNatures = this.referenceService.getNaturesByGroup(member.getMemberGroup());
        boolean hasTransactionFeedbacks = referenceNatures.contains(Reference.Nature.TRANSACTION);
        request.setAttribute("hasTransactionFeedbacks", (Object)hasTransactionFeedbacks);
        if (context.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            if (!(adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS)).getManagesGroups().contains(member.getGroup())) {
                throw new PermissionDeniedException();
            }
        }
        this.getReadDataBinder(context).writeAsString(form.getMember(), member);
        if (context.isMember()) {
            GroupFilterQuery groupFilterQuery = new GroupFilterQuery();
            groupFilterQuery.setGroup(memberUser.getMember().getMemberGroup());
            List<GroupFilter> groupFilters = this.groupFilterService.search(groupFilterQuery);
            if (groupFilters.size() > 0) {
                StringBuilder groupFiltersStr = new StringBuilder();
                for (GroupFilter groupFilter : groupFilters) {
                    if (!groupFilter.isShowInProfile()) continue;
                    if (!"".equals(groupFiltersStr.toString())) {
                        groupFiltersStr.append(", ");
                    }
                    groupFiltersStr.append(groupFilter.getName());
                }
                if (!"".equals(groupFiltersStr.toString())) {
                    request.setAttribute("groupFilters", (Object)groupFiltersStr.toString());
                }
            }
        }
        List<? extends OwneredImage> images = this.imageService.listByOwner(member);
        MemberGroupSettings groupSettings = member.getMemberGroup().getMemberSettings();
        boolean maxImages = groupSettings == null ? true : images.size() >= groupSettings.getMaxImagesPerMember();
        boolean usernameGenerated = this.settingsService.getAccessSettings().getUsernameGeneration() != AccessSettings.UsernameGeneration.NONE;
        boolean editable = myProfile;
        boolean byBroker = false;
        boolean canChangeName = false;
        boolean canChangeUsername = false;
        boolean canChangeEmail = false;
        boolean bl = removed = member.getGroup().getStatus() == Group.Status.REMOVED;
        if (!myProfile) {
            boolean canViewRecords = false;
            if (context.isAdmin()) {
                editable = this.permissionService.hasPermission(AdminMemberPermission.MEMBERS_CHANGE_PROFILE);
                canViewRecords = this.permissionService.hasPermission(AdminMemberPermission.RECORDS_VIEW);
                canChangeName = editable && this.permissionService.hasPermission(AdminMemberPermission.MEMBERS_CHANGE_NAME);
                canChangeEmail = editable && this.permissionService.hasPermission(AdminMemberPermission.MEMBERS_CHANGE_EMAIL);
                canChangeUsername = !usernameGenerated && editable && this.permissionService.hasPermission(AdminMemberPermission.MEMBERS_CHANGE_USERNAME);
            } else {
                byBroker = context.isBrokerOf(member);
                if (byBroker) {
                    editable = this.permissionService.hasPermission(BrokerPermission.MEMBERS_CHANGE_PROFILE);
                    canViewRecords = this.permissionService.hasPermission(BrokerPermission.MEMBER_RECORDS_VIEW);
                    canChangeName = editable && this.permissionService.hasPermission(BrokerPermission.MEMBERS_CHANGE_NAME);
                    canChangeEmail = editable && this.permissionService.hasPermission(BrokerPermission.MEMBERS_CHANGE_EMAIL);
                    boolean bl2 = canChangeUsername = !usernameGenerated && editable && this.permissionService.hasPermission(BrokerPermission.MEMBERS_CHANGE_USERNAME);
                }
            }
            if (canViewRecords) {
                request.setAttribute("countByRecordType", this.memberRecordService.countByType(member));
            }
        } else {
            canChangeName = this.permissionService.hasPermission(MemberPermission.PROFILE_CHANGE_NAME);
            canChangeEmail = this.permissionService.hasPermission(MemberPermission.PROFILE_CHANGE_EMAIL);
            canChangeUsername = !usernameGenerated && this.permissionService.hasPermission(MemberPermission.PROFILE_CHANGE_USERNAME);
        }
        Object loggedGroup = context.getGroup();
        List<MemberCustomField> allFields = this.memberCustomFieldService.list();
        List<MemberCustomField> customFields = removed ? allFields : this.customFieldHelper.onlyForGroup(allFields, member.getMemberGroup());
        HashMap<MemberCustomField, Boolean> editableFields = new HashMap<MemberCustomField, Boolean>();
        Iterator<MemberCustomField> it = customFields.iterator();
        while (it.hasNext()) {
            MemberCustomField.Access update;
            MemberCustomField field = it.next();
            MemberCustomField.Access visibility = field.getVisibilityAccess();
            if (visibility != null && !visibility.granted((Group)loggedGroup, myProfile, byBroker, false, false)) {
                it.remove();
            }
            editableFields.put(field, (update = field.getUpdateAccess()) != null && update.granted((Group)loggedGroup, myProfile, byBroker, false, false));
        }
        boolean hasCardType = false;
        if (member.getMemberGroup().getCardType() != null) {
            hasCardType = true;
        }
        PendingEmailChange pendingEmailChange = null;
        if (editable) {
            pendingEmailChange = this.elementService.getPendingEmailChange(member);
        }
        request.setAttribute("member", (Object)member);
        request.setAttribute("removed", (Object)(member.getGroup().getStatus() == Group.Status.REMOVED ? 1 : 0));
        request.setAttribute("hasAccounts", (Object)this.accountService.hasAccounts(member));
        request.setAttribute("disabledLogin", (Object)this.accessService.isLoginBlocked(member.getUser()));
        request.setAttribute("customFields", this.customFieldHelper.buildEntries(customFields, member.getCustomValues()));
        request.setAttribute("editableFields", editableFields);
        request.setAttribute("canChangeName", (Object)canChangeName);
        request.setAttribute("canChangeEmail", (Object)canChangeEmail);
        request.setAttribute("canChangeUsername", (Object)canChangeUsername);
        request.setAttribute("pendingEmailChange", (Object)pendingEmailChange);
        request.setAttribute("images", images);
        request.setAttribute("maxImages", (Object)maxImages);
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("byBroker", (Object)byBroker);
        request.setAttribute("myProfile", (Object)myProfile);
        request.setAttribute("profileOfOtherMember", (Object)profileOfOtherMember);
        request.setAttribute("profileOfBrokered", (Object)false);
        request.setAttribute("operatorCanViewReports", (Object)operatorCanViewReports);
        request.setAttribute("hasCardType", (Object)hasCardType);
        if (editable) {
            return context.getInputForward();
        }
        return context.findForward("view");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        Member currentMember;
        MemberProfileForm form = (MemberProfileForm)((Object)context.getForm());
        Member member = this.resolveMember(context);
        try {
            currentMember = (Member)this.elementService.load(member.getId(), Member.Relationships.BROKER);
        }
        catch (ClassCastException e) {
            throw new ValidationException();
        }
        Member broker = currentMember.getBroker();
        member.setBroker(broker);
        if (member.isTransient()) {
            throw new ValidationException();
        }
        boolean hadPendingEmailChange = this.elementService.getPendingEmailChange(member) != null;
        try {
            member = this.elementService.changeProfile(member);
        }
        catch (MailSendingException e) {
            return context.sendError("profile.error.changeEmailValidationFailed", new Object[0]);
        }
        PendingEmailChange pendingEmailChange = this.elementService.getPendingEmailChange(member);
        FormFile upload = form.getPicture();
        if (upload != null && upload.getFileSize() > 0) {
            try {
                this.imageService.save(member, form.getPictureCaption(), ImageHelper.ImageType.getByContentType(upload.getContentType()), upload.getFileName(), upload.getInputStream());
            }
            finally {
                upload.destroy();
            }
        }
        if (!hadPendingEmailChange && pendingEmailChange != null) {
            context.sendMessage("profile.modified.emailPending", pendingEmailChange.getNewEmail());
        } else {
            context.sendMessage("profile.modified", new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), super.handleSubmit(context), "memberId", member.getId());
    }

    @Override
    protected DataBinder<Member> initDataBinderForRead(ActionContext context) {
        BeanBinder dataBinder = (BeanBinder)super.initDataBinderForRead(context);
        dataBinder.registerBinder("hideEmail", PropertyBinder.instance(Boolean.TYPE, "hideEmail"));
        return dataBinder;
    }

    @Override
    protected DataBinder<Member> initDataBinderForWrite(ActionContext context) {
        BeanBinder dataBinder = (BeanBinder)super.initDataBinderForWrite(context);
        dataBinder.registerBinder("hideEmail", PropertyBinder.instance(Boolean.TYPE, "hideEmail"));
        BeanBinder userBinder = BeanBinder.instance(this.getUserClass(), "user");
        userBinder.registerBinder("username", PropertyBinder.instance(String.class, "username"));
        dataBinder.registerBinder("user", userBinder);
        BeanCollectionBinder collectionBinder = (BeanCollectionBinder)dataBinder.getMappings().get("customValues");
        BeanBinder elementBinder = (BeanBinder)collectionBinder.getElementBinder();
        elementBinder.registerBinder("hidden", PropertyBinder.instance(Boolean.TYPE, "hidden"));
        return dataBinder;
    }

    @Override
    protected void validateForm(ActionContext context) {
        Member member = this.resolveMember(context);
        this.elementService.validate(member, WhenSaving.PROFILE, false);
    }

    private Member resolveMember(ActionContext context) {
        MemberProfileForm form = (MemberProfileForm)((Object)context.getForm());
        return (Member)this.getWriteDataBinder(context).readFromString(form.getMember());
    }
}

