/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BasePublicFormAction;
import nl.strohalm.cyclos.controls.elements.CreateElementAction;
import nl.strohalm.cyclos.controls.members.CreateMemberForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.RegisteredMember;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.exceptions.MailSendingException;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.elements.WhenSaving;
import nl.strohalm.cyclos.services.elements.exceptions.UsernameAlreadyInUseException;
import nl.strohalm.cyclos.servlets.CaptchaServlet;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.validation.PasswordsDontMatchError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PublicCreateMemberAction
extends BasePublicFormAction
implements LocalSettingsChangeListener {
    private MemberCustomFieldService memberCustomFieldService;
    private DataBinder<Member> dataBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private CustomFieldHelper customFieldHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<Member> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                AccessSettings accessSettings = this.settingsService.getAccessSettings();
                this.dataBinder = CreateElementAction.getDataBinder(localSettings, accessSettings, Member.class, MemberUser.class, MemberGroup.class, MemberCustomField.class, MemberCustomFieldValue.class);
            }
            DataBinder<Member> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MemberCustomFieldService getMemberCustomFieldService() {
        return this.memberCustomFieldService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Override
    protected ActionForward handleDisplay(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getSession().getAttribute("loggedUser") != null) {
            try {
                response.sendRedirect("/" + request.getContextPath());
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
        return super.handleDisplay(mapping, actionForm, request, response);
    }

    @Override
    protected ActionForward handleSubmit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        User user;
        RegisteredMember registeredMember;
        CreateMemberForm form = (CreateMemberForm)actionForm;
        HttpSession session = request.getSession();
        if (!CaptchaServlet.checkChallenge(request, form.getCaptcha())) {
            session.setAttribute("forceBack", (Object)true);
            throw new ValidationException("createMember.captcha.invalid", new Object[0]);
        }
        Member member = this.getDataBinder().readFromString(form.getMember());
        try {
            registeredMember = (RegisteredMember)this.elementService.register(member, false, request.getRemoteAddr());
        }
        catch (UsernameAlreadyInUseException e) {
            ActionForward actionForward = ActionHelper.sendError(mapping, request, response, "createMember.public.alreadyExists", new Object[0]);
            session.setAttribute("forceBack", (Object)"forceBack");
            return actionForward;
        }
        catch (MailSendingException e) {
            return ActionHelper.sendError(mapping, request, response, "createMember.public.errorSendingMail", new Object[0]);
        }
        String message = registeredMember instanceof Member ? (((Member)registeredMember).isActive() ? ((user = ((Member)registeredMember).getUser()).getPassword() != null && user.getPasswordDate() == null ? "createMember.public.awaitingPassword" : "createMember.public.validated") : "createMember.public.awaitingActivation") : "createMember.public.awaitingMailValidation";
        session.removeAttribute("forceBack");
        ActionHelper.sendError(mapping, request, response, message, registeredMember.getUsername());
        return mapping.findForward("confirmation");
    }

    @Override
    protected void prepareForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MemberGroup group;
        CreateMemberForm form = (CreateMemberForm)actionForm;
        try {
            group = (MemberGroup)this.groupService.load(form.getGroupId(), new Relationship[0]);
            if (!group.isInitialGroup()) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        List<MemberCustomField> customFields = this.customFieldHelper.onlyForGroup(this.memberCustomFieldService.list(), group);
        Iterator<MemberCustomField> it = customFields.iterator();
        while (it.hasNext()) {
            MemberCustomField field = it.next();
            boolean use = true;
            MemberCustomField.Access visibility = field.getVisibilityAccess();
            if (visibility != null && !visibility.granted(group, true, false, true, false)) {
                use = false;
            } else {
                MemberCustomField.Access update = field.getUpdateAccess();
                if (update != null && !update.granted(group, true, false, true, false)) {
                    use = false;
                }
            }
            if (use) continue;
            it.remove();
        }
        request.setAttribute("formAction", (Object)mapping.getPath());
        request.setAttribute("customFields", customFields);
        request.setAttribute("isPublic", (Object)true);
        request.setAttribute("allowSetPassword", (Object)true);
        request.setAttribute("group", (Object)group);
    }

    @Override
    protected void validateForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws ValidationException {
        String password;
        ValidationException exc;
        CreateMemberForm form = (CreateMemberForm)actionForm;
        Member member = this.getDataBinder().readFromString(form.getMember());
        try {
            this.elementService.validate(member, WhenSaving.PUBLIC, form.isManualPassword());
            exc = new ValidationException();
        }
        catch (ValidationException e) {
            exc = e;
        }
        String captcha = form.getCaptcha();
        if (StringUtils.isEmpty((String)captcha) || !CaptchaServlet.checkChallenge(request, captcha)) {
            exc.addPropertyError("captcha", new ValidationError("createMember.captcha.invalid", new Object[0]));
        }
        try {
            password = StringUtils.trimToNull((String)member.getUser().getPassword());
        }
        catch (Exception e) {
            password = null;
        }
        String confirmPassword = StringUtils.trimToNull((String)form.getConfirmPassword());
        if (!(password == null || confirmPassword != null && ObjectUtils.equals((Object)confirmPassword, (Object)member.getUser().getPassword()))) {
            exc.addGeneralError(new PasswordsDontMatchError());
        }
        exc.throwIfHasErrors();
    }
}

