/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.elements.SearchElementsAction;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupFilterQuery;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;

public class SearchMembersAction
extends SearchElementsAction<FullTextMemberQuery> {
    protected MemberCustomFieldService memberCustomFieldService;
    protected GroupFilterService groupFilterService;
    protected CustomFieldHelper customFieldHelper;

    public static DataBinder<FullTextMemberQuery> memberQueryDataBinder(LocalSettings settings) {
        return SearchMembersAction.elementQueryDataBinder(settings, FullTextMemberQuery.class, MemberCustomFieldValue.class);
    }

    public GroupFilterService getGroupFilterService() {
        return this.groupFilterService;
    }

    public MemberCustomFieldService getMemberCustomFieldService() {
        return this.memberCustomFieldService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    protected boolean allowRemovedGroups() {
        return true;
    }

    @Override
    protected Class<? extends CustomFieldValue> getCustomFieldValueClass() {
        return MemberCustomFieldValue.class;
    }

    @Override
    protected Class<FullTextMemberQuery> getQueryClass() {
        return FullTextMemberQuery.class;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        FullTextMemberQuery memberQuery = (FullTextMemberQuery)super.prepareForm(context);
        memberQuery.fetch(Member.Relationships.IMAGES);
        List<MemberCustomField> fields = this.customFieldHelper.onlyForMemberSearch(this.memberCustomFieldService.list());
        request.setAttribute("customFields", this.customFieldHelper.buildEntries(fields, memberQuery.getCustomValues()));
        GroupFilterQuery groupFilterQuery = new GroupFilterQuery();
        if (context.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            groupFilterQuery.setAdminGroup(adminGroup);
            GroupQuery groupQuery = new GroupQuery();
            groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
            if (!this.allowRemovedGroups()) {
                groupQuery.setStatus(Group.Status.NORMAL);
            }
            groupQuery.setManagedBy(adminGroup);
            groupQuery.setGroupFilters(memberQuery.getGroupFilters());
            List<? extends Group> groups = this.groupService.search(groupQuery);
            request.setAttribute("groups", groups);
            if (CollectionUtils.isEmpty(groups)) {
                memberQuery.setGroups(groups);
            }
            if (this.permissionService.hasPermission(AdminMemberPermission.MEMBERS_REGISTER)) {
                ArrayList<MemberGroup> possibleNewGroups = new ArrayList<MemberGroup>();
                for (MemberGroup memberGroup : groups) {
                    if (!Group.Status.NORMAL.equals(memberGroup.getStatus())) continue;
                    possibleNewGroups.add(memberGroup);
                }
                request.setAttribute("possibleNewGroups", possibleNewGroups);
            }
        } else {
            MemberGroup memberGroup;
            if (context.isMember()) {
                memberGroup = (MemberGroup)context.getGroup();
            } else {
                Operator operator = (Operator)context.getElement();
                memberGroup = operator.getMember().getMemberGroup();
            }
            groupFilterQuery.setViewableBy(memberGroup);
        }
        List<GroupFilter> groupFilters = this.groupFilterService.search(groupFilterQuery);
        if (CollectionUtils.isNotEmpty(groupFilters)) {
            request.setAttribute("groupFilters", groupFilters);
        }
        Member broker = memberQuery.getBroker() == null ? null : (Member)this.elementService.load(memberQuery.getBroker().getId(), Element.Relationships.USER);
        memberQuery.setBroker(broker);
        return memberQuery;
    }
}

