/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.members.SearchMembersAjaxForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.elements.BrokerQuery;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import org.apache.commons.lang.ArrayUtils;

public class SearchMembersAjaxAction
extends BaseAjaxAction {
    private DataBinder<?> dataBinder;
    private DataBinder<?> dataBinderWithMaxScheduledPayments;

    public DataBinder<?> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = BeanCollectionBinder.instance(DataBinderHelper.simpleElementBinder());
        }
        return this.dataBinder;
    }

    public DataBinder<?> getDataBinderWithMaxScheduledPayments() {
        if (this.dataBinderWithMaxScheduledPayments == null) {
            BeanBinder<Map<String, Object>> elementBinder = DataBinderHelper.simpleElementBinder();
            elementBinder.registerBinder("maxScheduledPayments", PropertyBinder.instance(Integer.TYPE, "group.memberSettings.maxSchedulingPayments"));
            this.dataBinderWithMaxScheduledPayments = BeanCollectionBinder.instance(elementBinder);
        }
        return this.dataBinderWithMaxScheduledPayments;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        SearchMembersAjaxForm form = (SearchMembersAjaxForm)((Object)context.getForm());
        MemberQuery memberQuery = form.isBrokers() ? new BrokerQuery() : new MemberQuery();
        memberQuery.setViewableGroup(form.getViewableGroup());
        if (form.isEnabled()) {
            memberQuery.setEnabled(form.isEnabled());
        }
        memberQuery.setExcludeRemoved(true);
        memberQuery.limitResults(localSettings.getMaxAjaxResults());
        memberQuery.setName(form.getName());
        memberQuery.setUsername(form.getUsername());
        if (context.isBroker() && form.isBrokered()) {
            Member broker = (Member)context.getElement();
            memberQuery.setBroker(broker);
        }
        Element exclude = form.getExclude() != null ? EntityHelper.reference(Element.class, form.getExclude()) : (context.isOperator() ? (Element)((Object)context.getAccountOwner()) : context.getElement());
        memberQuery.setExcludeElements(Collections.singleton(exclude));
        if (form.isMaxScheduledPayments()) {
            memberQuery.fetch(Element.Relationships.GROUP);
        }
        Collection<MemberGroup> groups = this.resolveGroups(context);
        memberQuery.setGroups(groups);
        List<? extends Element> members = this.elementService.search(memberQuery);
        String json = (form.isMaxScheduledPayments() ? this.getDataBinderWithMaxScheduledPayments() : this.getDataBinder()).readAsString(members);
        this.responseHelper.writeJSON(context.getResponse(), json);
    }

    private Collection<MemberGroup> resolveGroups(ActionContext context) {
        HashSet<MemberGroup> groups = null;
        SearchMembersAjaxForm form = (SearchMembersAjaxForm)((Object)context.getForm());
        if (ArrayUtils.isNotEmpty((Object[])form.getGroupIds())) {
            groups = new HashSet<MemberGroup>();
            for (Long id : form.getGroupIds()) {
                if (id <= 0L) continue;
                groups.add((MemberGroup)this.groupService.load(id, new Relationship[0]));
            }
        }
        return groups;
    }
}

