/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.activities;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.members.activities.ActivitiesForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.services.elements.ActivitiesVO;
import nl.strohalm.cyclos.services.elements.MemberService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ActivitiesAction
extends BaseAction {
    private MemberService memberService;

    public MemberService getMemberService() {
        return this.memberService;
    }

    @Inject
    public void setMemberService(MemberService memberService) {
        this.memberService = memberService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        Member member;
        HttpServletRequest request = context.getRequest();
        ActivitiesForm form = (ActivitiesForm)((Object)context.getForm());
        boolean myActivities = false;
        if (form.getMemberId() <= 0L || ((Entity)context.getElement()).getId().equals(form.getMemberId())) {
            member = context.getMember();
            myActivities = true;
        } else {
            Object element = this.elementService.load(form.getMemberId(), Element.Relationships.USER, Element.Relationships.GROUP);
            if (!(element instanceof Member)) {
                throw new ValidationException();
            }
            member = (Member)element;
        }
        ActivitiesVO activities = this.memberService.getActivities(member);
        request.setAttribute("member", (Object)member);
        request.setAttribute("activities", (Object)activities);
        request.setAttribute("myActivities", (Object)myActivities);
        RequestHelper.storeEnum(request, Reference.Level.class, "referenceLevels");
        RequestHelper.storeEnumMap(request, Ad.Status.class, "adStatus");
        return context.getInputForward();
    }
}

