/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.adinterests;

import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.adinterests.EditAdInterestForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupFilterQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.adInterests.AdInterest;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.ads.AdCategoryService;
import nl.strohalm.cyclos.services.elements.AdInterestService;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;

public class EditAdInterestAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private AdInterestService adInterestService;
    private AdCategoryService adCategoryService;
    private GroupFilterService groupFilterService;
    private CurrencyService currencyService;
    private AccountTypeService accountTypeService;
    private DataBinder<AdInterest> dataBinder;

    public DataBinder<AdInterest> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            BeanBinder<AdInterest> binder = BeanBinder.instance(AdInterest.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("owner", PropertyBinder.instance(Member.class, "owner", ReferenceConverter.instance(Member.class)));
            binder.registerBinder("title", PropertyBinder.instance(String.class, "title"));
            binder.registerBinder("type", PropertyBinder.instance(Ad.TradeType.class, "type"));
            binder.registerBinder("category", PropertyBinder.instance(AdCategory.class, "category", ReferenceConverter.instance(AdCategory.class)));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member", ReferenceConverter.instance(Member.class)));
            binder.registerBinder("groupFilter", PropertyBinder.instance(GroupFilter.class, "groupFilter", ReferenceConverter.instance(GroupFilter.class)));
            binder.registerBinder("initialPrice", PropertyBinder.instance(BigDecimal.class, "initialPrice", settings.getNumberConverter()));
            binder.registerBinder("finalPrice", PropertyBinder.instance(BigDecimal.class, "finalPrice", settings.getNumberConverter()));
            binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
            binder.registerBinder("keywords", PropertyBinder.instance(String.class, "keywords"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setAdCategoryService(AdCategoryService adCategoryService) {
        this.adCategoryService = adCategoryService;
    }

    @Inject
    public void setAdInterestService(AdInterestService adInterestService) {
        this.adInterestService = adInterestService;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        AdInterest adInterest = this.resolveAdInterest(context);
        boolean isInsert = adInterest.isTransient();
        this.adInterestService.save(adInterest);
        context.sendMessage(isInsert ? "adInterest.inserted" : "adInterest.modified", new Object[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        MemberAccountType defaultAccountType;
        HttpServletRequest request = context.getRequest();
        EditAdInterestForm form = (EditAdInterestForm)((Object)context.getForm());
        AdInterest adInterest = this.resolveAdInterest(context);
        Long id = adInterest.getId();
        if (id != null) {
            adInterest = this.adInterestService.load(adInterest.getId(), RelationshipHelper.nested(AdInterest.Relationships.MEMBER, Element.Relationships.USER));
        }
        this.getDataBinder().writeAsString(form.getAdInterest(), adInterest);
        request.setAttribute("adInterest", (Object)adInterest);
        RequestHelper.storeEnum(request, Ad.TradeType.class, "tradeTypes");
        request.setAttribute("adCategories", this.adCategoryService.listLeaf());
        MemberGroup memberGroup = (MemberGroup)context.getGroup();
        GroupFilterQuery groupFilterQuery = new GroupFilterQuery();
        groupFilterQuery.setViewableBy(memberGroup);
        List<GroupFilter> groupFilters = this.groupFilterService.search(groupFilterQuery);
        if (groupFilters.size() > 0) {
            request.setAttribute("groupFilters", groupFilters);
        }
        List<Currency> currencies = this.currencyService.listByMemberGroup(memberGroup);
        request.setAttribute("currencies", currencies);
        if (currencies.size() == 1) {
            request.setAttribute("singleCurrency", (Object)currencies.get(0));
        } else if (currencies.size() > 1 && adInterest.getCurrency() == null && (defaultAccountType = this.accountTypeService.getDefault(memberGroup, AccountType.Relationships.CURRENCY)) != null) {
            form.setAdInterest("currency", CoercionHelper.coerce(String.class, defaultAccountType.getCurrency()));
        }
    }

    @Override
    protected void validateForm(ActionContext context) {
        AdInterest adInterest = this.resolveAdInterest(context);
        this.adInterestService.validate(adInterest);
    }

    private AdInterest resolveAdInterest(ActionContext context) {
        EditAdInterestForm form = (EditAdInterestForm)((Object)context.getForm());
        AdInterest adInterest = this.getDataBinder().readFromString(form.getAdInterest());
        if (adInterest.getOwner() == null && context.isMember()) {
            adInterest.setOwner((Member)context.getElement());
        }
        if (adInterest.getType() == null) {
            adInterest.setType(Ad.TradeType.OFFER);
        }
        return adInterest;
    }
}

