/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.agreements;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.agreements.EditRegistrationAgreementForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.members.RegistrationAgreement;
import nl.strohalm.cyclos.services.elements.RegistrationAgreementService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;

public class EditRegistrationAgreementAction
extends BaseFormAction {
    private RegistrationAgreementService registrationAgreementService;
    private DataBinder<RegistrationAgreement> dataBinder;

    @Inject
    public void setRegistrationAgreementService(RegistrationAgreementService registrationAgreementService) {
        this.registrationAgreementService = registrationAgreementService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        EditRegistrationAgreementForm form = (EditRegistrationAgreementForm)((Object)context.getForm());
        RegistrationAgreement registrationAgreement = this.getDataBinder().readFromString((Object)form);
        boolean isInsert = registrationAgreement.isTransient();
        this.registrationAgreementService.save(registrationAgreement);
        if (isInsert) {
            context.sendMessage("registrationAgreement.inserted", new Object[0]);
        } else {
            context.sendMessage("registrationAgreement.modified", new Object[0]);
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditRegistrationAgreementForm form = (EditRegistrationAgreementForm)((Object)context.getForm());
        long id = form.getRegistrationAgreementId();
        boolean isInsert = id <= 0L;
        RegistrationAgreement registrationAgreement = isInsert ? new RegistrationAgreement() : this.registrationAgreementService.load(id, new Relationship[0]);
        this.getDataBinder().writeAsString((Object)form, registrationAgreement);
        request.setAttribute("registrationAgreement", (Object)registrationAgreement);
        request.setAttribute("isInsert", (Object)isInsert);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditRegistrationAgreementForm form = (EditRegistrationAgreementForm)((Object)context.getForm());
        RegistrationAgreement registrationAgreement = this.getDataBinder().readFromString((Object)form);
        this.registrationAgreementService.validate(registrationAgreement);
    }

    private DataBinder<RegistrationAgreement> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<RegistrationAgreement> binder = BeanBinder.instance(RegistrationAgreement.class, "registrationAgreement");
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("contents", PropertyBinder.instance(String.class, "contents", HtmlConverter.instance()));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

