/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;

public class BrokeredIterator
implements Iterator<Map<String, Object>> {
    private final Iterator<Brokering> iterator;
    private final boolean showLoanData;
    private final LoanService loanService;

    public BrokeredIterator(Iterator<Brokering> iterator, LoanService loanService, boolean showLoanData) {
        this.iterator = iterator;
        this.showLoanData = showLoanData;
        this.loanService = loanService;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Map<String, Object> next() {
        Brokering brokering = this.iterator.next();
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("brokering", brokering);
        if (this.showLoanData) {
            TransactionSummaryVO loans = this.loanService.loanSummary(brokering.getBrokered());
            row.put("loans", loans);
        }
        return row;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

