/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.brokering.ChangeBrokerForm;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.remarks.BrokerRemark;
import nl.strohalm.cyclos.services.elements.BrokeringService;
import nl.strohalm.cyclos.services.elements.ChangeBrokerDTO;
import nl.strohalm.cyclos.services.elements.RemarkService;
import nl.strohalm.cyclos.services.elements.exceptions.CircularBrokeringException;
import nl.strohalm.cyclos.services.elements.exceptions.MemberAlreadyInBrokeringsException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ChangeBrokerAction
extends BaseFormAction {
    private BrokeringService brokeringService;
    private DataBinder<ChangeBrokerDTO> dataBinder;
    private RemarkService remarkService;

    public static DataBinder<ChangeBrokerDTO> changeBrokerDTODataBinder() {
        BeanBinder<ChangeBrokerDTO> binder = BeanBinder.instance(ChangeBrokerDTO.class);
        binder.registerBinder("member", PropertyBinder.instance(Member.class, "memberId"));
        binder.registerBinder("newBroker", PropertyBinder.instance(Member.class, "newBrokerId"));
        binder.registerBinder("comments", PropertyBinder.instance(String.class, "comments"));
        binder.registerBinder("suspendCommission", PropertyBinder.instance(Boolean.TYPE, "suspendCommission"));
        return binder;
    }

    public BrokeringService getBrokeringService() {
        return this.brokeringService;
    }

    public DataBinder<ChangeBrokerDTO> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = ChangeBrokerAction.changeBrokerDTODataBinder();
        }
        return this.dataBinder;
    }

    public RemarkService getRemarkService() {
        return this.remarkService;
    }

    @Inject
    public void setBrokeringService(BrokeringService brokeringService) {
        this.brokeringService = brokeringService;
    }

    @Inject
    public void setRemarkService(RemarkService remarkService) {
        this.remarkService = remarkService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        ChangeBrokerForm form = (ChangeBrokerForm)((Object)context.getForm());
        ChangeBrokerDTO dto = this.getDataBinder().readFromString((Object)form);
        try {
            this.brokeringService.changeBroker(dto);
        }
        catch (MemberAlreadyInBrokeringsException e) {
            return context.sendError("brokering.error.memberAlreadyInBrokering", new Object[0]);
        }
        catch (CircularBrokeringException e) {
            return context.sendError("brokering.error.circularBrokering", new Object[0]);
        }
        context.sendMessage("changeBroker.changed", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "memberId", form.getMemberId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        Object element;
        ChangeBrokerForm form = (ChangeBrokerForm)((Object)context.getForm());
        Member member = null;
        if (form.getMemberId() > 0L && (element = this.elementService.load(form.getMemberId(), Element.Relationships.USER, RelationshipHelper.nested(Member.Relationships.BROKER, Element.Relationships.USER))) instanceof Member) {
            member = (Member)element;
        }
        if (member == null) {
            throw new ValidationException();
        }
        HttpServletRequest request = context.getRequest();
        request.setAttribute("member", member);
        List<BrokerRemark> history = this.remarkService.listBrokerRemarksFor(member);
        request.setAttribute("history", history);
    }

    @Override
    protected void validateForm(ActionContext context) {
        ChangeBrokerForm form = (ChangeBrokerForm)((Object)context.getForm());
        ChangeBrokerDTO dto = this.getDataBinder().readFromString((Object)form);
        this.brokeringService.validate(dto);
    }
}

