/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.brokering.DefaultBrokerCommissionsForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFeeQuery;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.DefaultBrokerCommission;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.elements.CommissionService;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class DefaultBrokerCommissionsAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private CommissionService commissionService;
    private TransactionFeeService transactionFeeService;
    private DataBinder<Collection<DefaultBrokerCommissionDTO>> dataBinder;

    public DataBinder<Collection<DefaultBrokerCommissionDTO>> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<DefaultBrokerCommissionDTO> beanBinder = BeanBinder.instance(DefaultBrokerCommissionDTO.class);
            beanBinder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            beanBinder.registerBinder("brokerCommission", PropertyBinder.instance(BrokerCommission.class, "brokerCommission"));
            beanBinder.registerBinder("type", PropertyBinder.instance(Amount.Type.class, "type"));
            beanBinder.registerBinder("value", PropertyBinder.instance(BigDecimal.class, "value", localSettings.getNumberConverter()));
            beanBinder.registerBinder("count", PropertyBinder.instance(Integer.class, "count"));
            beanBinder.registerBinder("when", PropertyBinder.instance(BrokerCommission.When.class, "when"));
            BeanCollectionBinder<DefaultBrokerCommissionDTO> defaultBrokerCommissionsBinder = BeanCollectionBinder.instance(beanBinder, ArrayList.class);
            this.dataBinder = defaultBrokerCommissionsBinder;
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setCommissionService(CommissionService commissionService) {
        this.commissionService = commissionService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        DefaultBrokerCommissionsForm form = (DefaultBrokerCommissionsForm)((Object)context.getForm());
        Member broker = (Member)context.getElement();
        List defaultBrokerCommissionsDTO = (List)this.getDataBinder().readFromString(form.getDefaultBrokerCommission());
        List<DefaultBrokerCommission> defaultBrokerCommissions = this.dtoListToEntityList(broker, defaultBrokerCommissionsDTO);
        defaultBrokerCommissions = this.commissionService.saveDefaultBrokerCommissions(defaultBrokerCommissions);
        context.sendMessage("defaultBrokerCommission.updated", new Object[0]);
        return context.getSuccessForward();
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        if (!context.isBroker()) {
            throw new ValidationException();
        }
        Member broker = (Member)context.getElement();
        BrokerGroup brokerGroup = (BrokerGroup)broker.getGroup();
        TransactionFeeQuery transactionFeeQuery = new TransactionFeeQuery();
        transactionFeeQuery.setEntityType(BrokerCommission.class);
        transactionFeeQuery.setGeneratedTransferTypeFromNature(AccountType.Nature.MEMBER);
        transactionFeeQuery.setBrokerGroup(brokerGroup);
        transactionFeeQuery.setReturnDisabled(true);
        List<? extends TransactionFee> groupCommissions = this.transactionFeeService.search(transactionFeeQuery);
        List<DefaultBrokerCommission> currentDefaults = this.commissionService.loadDefaultBrokerCommissions(broker, DefaultBrokerCommission.Relationships.BROKER_COMMISSION);
        List<DefaultBrokerCommission> defaultBrokerCommissions = this.buildCommissions(groupCommissions, currentDefaults);
        request.setAttribute("broker", (Object)broker);
        request.setAttribute("defaultBrokerCommissions", defaultBrokerCommissions);
        RequestHelper.storeEnum(request, BrokerCommission.When.class, "whens");
        RequestHelper.storeEnum(request, Amount.Type.class, "amountTypes");
    }

    @Override
    protected void validateForm(ActionContext context) {
        DefaultBrokerCommissionsForm form = (DefaultBrokerCommissionsForm)((Object)context.getForm());
        Member broker = (Member)context.getElement();
        List defaultBrokerCommissionsDTO = (List)this.getDataBinder().readFromString(form.getDefaultBrokerCommission());
        List<DefaultBrokerCommission> defaultBrokerCommissions = this.dtoListToEntityList(broker, defaultBrokerCommissionsDTO);
        this.commissionService.validateDefaultBrokerCommissions(defaultBrokerCommissions);
    }

    private List<DefaultBrokerCommission> buildCommissions(List<BrokerCommission> groupCommissions, List<DefaultBrokerCommission> currentDefaults) {
        ArrayList<DefaultBrokerCommission> defaultBrokerCommissions = new ArrayList<DefaultBrokerCommission>();
        for (BrokerCommission groupCommission : groupCommissions) {
            DefaultBrokerCommission defaultBrokerCommission = null;
            for (DefaultBrokerCommission currentDefault : currentDefaults) {
                if (!currentDefault.getBrokerCommission().equals(groupCommission)) continue;
                defaultBrokerCommission = currentDefault;
                break;
            }
            if (defaultBrokerCommission == null) {
                defaultBrokerCommission = new DefaultBrokerCommission();
                defaultBrokerCommission.setBrokerCommission(groupCommission);
                defaultBrokerCommission.setAmount(groupCommission.getAmount());
                defaultBrokerCommission.setWhen(groupCommission.getWhen());
                defaultBrokerCommission.setCount(groupCommission.getCount());
            }
            defaultBrokerCommissions.add(defaultBrokerCommission);
        }
        return defaultBrokerCommissions;
    }

    private List<DefaultBrokerCommission> dtoListToEntityList(Member broker, List<DefaultBrokerCommissionDTO> dtoList) {
        ArrayList<DefaultBrokerCommission> defaultBrokerCommissions = new ArrayList<DefaultBrokerCommission>();
        for (DefaultBrokerCommissionDTO dto : dtoList) {
            Amount amount = new Amount();
            amount.setType(dto.getType());
            amount.setValue(dto.getValue());
            DefaultBrokerCommission defaultBrokerCommission = new DefaultBrokerCommission();
            defaultBrokerCommission.setId(dto.getId());
            defaultBrokerCommission.setBrokerCommission(dto.getBrokerCommission());
            defaultBrokerCommission.setBroker(broker);
            defaultBrokerCommission.setAmount(amount);
            defaultBrokerCommission.setCount(dto.getCount());
            defaultBrokerCommission.setWhen(dto.getWhen());
            defaultBrokerCommissions.add(defaultBrokerCommission);
        }
        return defaultBrokerCommissions;
    }

    public static class DefaultBrokerCommissionDTO {
        private Long id;
        private Member broker;
        private BrokerCommission brokerCommission;
        private Amount.Type type;
        private BigDecimal value;
        private Integer count;
        private BrokerCommission.When when;

        public Member getBroker() {
            return this.broker;
        }

        public BrokerCommission getBrokerCommission() {
            return this.brokerCommission;
        }

        public Integer getCount() {
            return this.count;
        }

        public Long getId() {
            return this.id;
        }

        public Amount.Type getType() {
            return this.type;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public BrokerCommission.When getWhen() {
            return this.when;
        }

        public void setBroker(Member broker) {
            this.broker = broker;
        }

        public void setBrokerCommission(BrokerCommission brokerCommission) {
            this.brokerCommission = brokerCommission;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setType(Amount.Type type) {
            this.type = type;
        }

        public void setValue(BigDecimal value) {
            this.value = value;
        }

        public void setWhen(BrokerCommission.When when) {
            this.when = when;
        }
    }
}

