/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.brokering.EditBrokerCommissionContractForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.elements.BrokeringService;
import nl.strohalm.cyclos.services.elements.CommissionService;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditBrokerCommissionContractAction
extends BaseFormAction {
    private BrokeringService brokeringService;
    private CommissionService commissionService;
    private TransactionFeeService transactionFeeService;
    private DataBinder<BrokerCommissionContract> dataBinder;

    public DataBinder<BrokerCommissionContract> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<BrokerCommissionContract> binder = BeanBinder.instance(BrokerCommissionContract.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("brokering", PropertyBinder.instance(Brokering.class, "brokering"));
            binder.registerBinder("brokerCommission", PropertyBinder.instance(BrokerCommission.class, "brokerCommission"));
            binder.registerBinder("period", DataBinderHelper.rawPeriodBinder(localSettings, "period"));
            binder.registerBinder("amount", DataBinderHelper.highPrecisionAmountConverter("amount", localSettings));
            binder.registerBinder("status", PropertyBinder.instance(BrokerCommissionContract.Status.class, "status"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setBrokeringService(BrokeringService brokeringService) {
        this.brokeringService = brokeringService;
    }

    @Inject
    public void setCommissionService(CommissionService commissionService) {
        this.commissionService = commissionService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditBrokerCommissionContractForm form = (EditBrokerCommissionContractForm)((Object)context.getForm());
        BrokerCommissionContract brokerCommissionContract = this.getDataBinder().readFromString(form.getBrokerCommissionContract());
        boolean isInsert = brokerCommissionContract.isTransient();
        brokerCommissionContract = this.commissionService.saveBrokerCommissionContract(brokerCommissionContract);
        context.sendMessage(isInsert ? "brokerCommissionContract.inserted" : "brokerCommissionContract.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "brokerCommissionContractId", brokerCommissionContract.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditBrokerCommissionContractForm form = (EditBrokerCommissionContractForm)((Object)context.getForm());
        long brokerCommissionContractId = form.getBrokerCommissionContractId();
        long brokerCommissionId = form.getBrokerCommissionId();
        long memberId = form.getMemberId();
        boolean byAdmin = false;
        boolean byBroker = false;
        boolean isInsert = false;
        boolean editable = false;
        boolean cancelable = false;
        boolean canAcceptOrDeny = false;
        BrokerCommissionContract brokerCommissionContract = null;
        if (brokerCommissionContractId > 0L) {
            try {
                brokerCommissionContract = this.commissionService.loadBrokerCommissionContract(brokerCommissionContractId, RelationshipHelper.nested(BrokerCommissionContract.Relationships.BROKERING, Brokering.Relationships.BROKER));
            }
            catch (EntityNotFoundException e) {
                throw new ValidationException("brokerCommissionContract.error.contractNotFound", new Object[0]);
            }
            BrokerCommissionContract.Status status = brokerCommissionContract.getStatus();
            if (context.isAdmin()) {
                byAdmin = true;
            } else {
                byBroker = this.isByBroker(context, brokerCommissionContract);
            }
            if (byAdmin) {
                if (status == BrokerCommissionContract.Status.ACTIVE || status == BrokerCommissionContract.Status.PENDING) {
                    cancelable = true;
                }
            } else if (byBroker) {
                if (status == BrokerCommissionContract.Status.PENDING && this.permissionService.hasPermission(BrokerPermission.MEMBERS_MANAGE_CONTRACTS)) {
                    editable = true;
                }
                if (status == BrokerCommissionContract.Status.ACTIVE) {
                    cancelable = true;
                }
            } else {
                canAcceptOrDeny = status == BrokerCommissionContract.Status.PENDING;
            }
        } else {
            byBroker = true;
            isInsert = true;
            editable = true;
            if (context.isAdmin() || memberId < 1L || brokerCommissionId < 1L) {
                throw new ValidationException();
            }
            Member broker = (Member)context.getElement();
            Member member = (Member)this.elementService.load(memberId, new Relationship[0]);
            Brokering brokering = this.brokeringService.getBrokering(broker, member);
            BrokerCommission brokerCommission = (BrokerCommission)this.transactionFeeService.load(brokerCommissionId, new Relationship[0]);
            brokerCommissionContract = new BrokerCommissionContract();
            brokerCommissionContract.setBrokering(brokering);
            brokerCommissionContract.setBrokerCommission(brokerCommission);
            brokerCommissionContract.setStatus(BrokerCommissionContract.Status.PENDING);
        }
        this.getDataBinder().writeAsString(form.getBrokerCommissionContract(), brokerCommissionContract);
        request.setAttribute("brokerCommissionContract", (Object)brokerCommissionContract);
        request.setAttribute("byAdmin", (Object)byAdmin);
        request.setAttribute("byBroker", (Object)byBroker);
        request.setAttribute("isInsert", (Object)isInsert);
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("cancelable", (Object)cancelable);
        request.setAttribute("canAcceptOrDeny", (Object)canAcceptOrDeny);
        RequestHelper.storeEnum(request, Amount.Type.class, "amountTypes");
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditBrokerCommissionContractForm form = (EditBrokerCommissionContractForm)((Object)context.getForm());
        BrokerCommissionContract brokerCommissionContract = this.getDataBinder().readFromString(form.getBrokerCommissionContract());
        this.commissionService.validateBrokerCommissionContract(brokerCommissionContract);
    }

    private boolean isByBroker(ActionContext context, BrokerCommissionContract brokerCommissionContract) {
        Member broker = brokerCommissionContract.getBrokering().getBroker();
        return ((Entity)context.getElement()).equals(broker);
    }
}

