/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.members.brokering.BrokeredIterator;
import nl.strohalm.cyclos.controls.members.brokering.ListBrokeringsAction;
import nl.strohalm.cyclos.controls.members.brokering.ListBrokeringsForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.members.BrokeringQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.elements.BrokeringService;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.conversion.CustomFieldConverter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class ExportBrokeringsToCsvAction
extends BaseCsvAction {
    private BrokeringService brokeringService;
    private MemberCustomFieldService memberCustomFieldService;
    private LoanService loanService;
    private DataBinder<BrokeringQuery> dataBinder;

    public MemberCustomFieldService getMemberCustomFieldService() {
        return this.memberCustomFieldService;
    }

    @Inject
    public void setBrokeringService(BrokeringService brokeringService) {
        this.brokeringService = brokeringService;
    }

    @Inject
    public void setLoanService(LoanService loanService) {
        this.loanService = loanService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Override
    protected Iterable<?> executeQuery(ActionContext context) {
        ListBrokeringsForm form = (ListBrokeringsForm)((Object)context.getForm());
        BrokeringQuery query = this.getDataBinder().readFromString(form.getQuery());
        if (query.getBroker() == null) {
            Object element;
            Member broker = null;
            Object loggedElement = context.getElement();
            if (form.getMemberId() <= 0L || ((Entity)loggedElement).getId().equals(form.getMemberId())) {
                if (context.isMember()) {
                    broker = (Member)context.getElement();
                }
            } else if (context.isAdmin() && (element = this.elementService.load(form.getMemberId(), Element.Relationships.USER, Element.Relationships.GROUP)) instanceof Member) {
                broker = (Member)element;
            }
            query.setBroker(broker);
        }
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        final boolean showLoanData = query.getStatus() == BrokeringQuery.Status.PENDING ? false : (context.isAdmin() ? this.permissionService.hasPermission(AdminMemberPermission.BROKERINGS_VIEW_LOANS) : this.permissionService.hasPermission(BrokerPermission.LOANS_VIEW));
        query.fetch(RelationshipHelper.nested(Brokering.Relationships.BROKERED, Element.Relationships.GROUP), RelationshipHelper.nested(Brokering.Relationships.BROKERED, Member.Relationships.CUSTOM_VALUES));
        final List<Brokering> brokerings = this.brokeringService.search(query);
        Iterable result = new Iterable(){

            public Iterator iterator() {
                return new BrokeredIterator(brokerings.iterator(), ExportBrokeringsToCsvAction.this.loanService, showLoanData);
            }
        };
        return result;
    }

    @Override
    protected String fileName(ActionContext context) {
        Object loggedUser = context.getUser();
        return "brokerings_" + ((User)loggedUser).getUsername() + ".csv";
    }

    @Override
    protected CSVWriter<?> resolveCSVWriter(ActionContext context) {
        LocalSettings settings = this.settingsService.getLocalSettings();
        CSVWriter<Brokering> csv = CSVWriter.instance(Brokering.class, settings);
        String memberPrefix = "brokering.brokered.";
        csv.addColumn(context.message("member.id", new Object[0]), "brokering.brokered.id");
        csv.addColumn(context.message("member.username", new Object[0]), "brokering.brokered.username");
        csv.addColumn(context.message("member.name", new Object[0]), "brokering.brokered.name");
        csv.addColumn(context.message("member.email", new Object[0]), "brokering.brokered.email");
        csv.addColumn(context.message("member.lastLogin", new Object[0]), "brokering.brokered.user.lastLogin", settings.getDateTimeConverter());
        List customFields = this.memberCustomFieldService.list();
        for (MemberCustomField field : customFields) {
            csv.addColumn(field.getName(), "brokering.brokered.customValues", new CustomFieldConverter(field, this.elementService, settings));
        }
        csv.addColumn(context.message("brokering.loans.count", new Object[0]), "loans.count");
        csv.addColumn(context.message("brokering.loans.amount", new Object[0]), "loans.amount");
        return csv;
    }

    private DataBinder<BrokeringQuery> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = ListBrokeringsAction.brokeringDataBinder();
        }
        return this.dataBinder;
    }
}

