/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.brokering.ListBrokerCommissionContractsForm;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContractQuery;
import nl.strohalm.cyclos.services.elements.CommissionChargeStatusDTO;
import nl.strohalm.cyclos.services.elements.CommissionService;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ListBrokerCommissionContractsAction
extends BaseQueryAction {
    private CommissionService commissionService;
    private TransactionFeeService transactionFeeService;

    public TransactionFeeService getTransactionFeeService() {
        return this.transactionFeeService;
    }

    @Inject
    public void setCommissionService(CommissionService commissionService) {
        this.commissionService = commissionService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        BrokerCommissionContractQuery query = (BrokerCommissionContractQuery)queryParameters;
        List<BrokerCommissionContract> brokerCommissionContracts = this.commissionService.searchBrokerCommissionContracts(query);
        context.getRequest().setAttribute("brokerCommissionContracts", brokerCommissionContracts);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        ListBrokerCommissionContractsForm form = (ListBrokerCommissionContractsForm)((Object)context.getForm());
        Member broker = null;
        Member member = null;
        boolean myContracts = false;
        long memberId = form.getMemberId();
        if (memberId > 0L) {
            member = (Member)this.elementService.load(memberId, Element.Relationships.GROUP);
            if (!context.isBrokerOf(member)) {
                throw new ValidationException();
            }
            broker = (Member)context.getElement();
        } else {
            member = (Member)context.getElement();
            myContracts = true;
        }
        request.setAttribute("member", (Object)member);
        request.setAttribute("broker", broker);
        request.setAttribute("myContracts", (Object)myContracts);
        List<CommissionChargeStatusDTO> commissionChargeStatusList = this.commissionService.getCommissionChargeStatus(member);
        request.setAttribute("commissionChargeStatusList", commissionChargeStatusList);
        if (context.isBroker() && memberId > 0L && this.permissionService.hasPermission(BrokerPermission.MEMBERS_MANAGE_CONTRACTS)) {
            request.setAttribute("brokerCommissions", this.commissionService.listPossibleCommissionsForNewContract(member));
        }
        BrokerCommissionContractQuery query = new BrokerCommissionContractQuery();
        query.setBroker(broker);
        query.setMember(member);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }
}

