/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.brokering.ListBrokeringsForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.BrokeringQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.services.elements.BrokeringService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;

public class ListBrokeringsAction
extends BaseQueryAction {
    private BrokeringService brokeringService;
    private DataBinder<BrokeringQuery> dataBinder;

    public static DataBinder<BrokeringQuery> brokeringDataBinder() {
        BeanBinder<BrokeringQuery> binder = BeanBinder.instance(BrokeringQuery.class);
        binder.registerBinder("status", PropertyBinder.instance(BrokeringQuery.Status.class, "status"));
        binder.registerBinder("username", PropertyBinder.instance(String.class, "username"));
        binder.registerBinder("groups", SimpleCollectionBinder.instance(Group.class, "groups"));
        binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
        return binder;
    }

    public BrokeringService getBrokeringService() {
        return this.brokeringService;
    }

    public DataBinder<BrokeringQuery> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = ListBrokeringsAction.brokeringDataBinder();
        }
        return this.dataBinder;
    }

    @Inject
    public void setBrokeringService(BrokeringService brokeringService) {
        this.brokeringService = brokeringService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        BrokeringQuery query = (BrokeringQuery)queryParameters;
        List<Brokering> brokerings = this.brokeringService.search(query);
        context.getRequest().setAttribute("brokerings", brokerings);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        ListBrokeringsForm form = (ListBrokeringsForm)((Object)context.getForm());
        boolean myBrokerings = false;
        boolean canChangeBroker = false;
        Member broker = null;
        Object loggedElement = context.getElement();
        if (form.getMemberId() <= 0L || ((Entity)loggedElement).getId().equals(form.getMemberId())) {
            if (context.isMember()) {
                broker = (Member)context.getElement();
                myBrokerings = true;
            }
        } else if (context.isAdmin()) {
            Object element = this.elementService.load(form.getMemberId(), Element.Relationships.USER, Element.Relationships.GROUP);
            if (element instanceof Member) {
                broker = (Member)element;
            }
            canChangeBroker = this.permissionService.hasPermission(AdminMemberPermission.BROKERINGS_CHANGE_BROKER);
        }
        if (broker == null || !broker.getMemberGroup().isBroker()) {
            throw new ValidationException();
        }
        BrokerGroup brokerGroup = (BrokerGroup)broker.getGroup();
        brokerGroup = (BrokerGroup)this.groupService.load(brokerGroup.getId(), BrokerGroup.Relationships.POSSIBLE_INITIAL_GROUPS);
        ArrayList<MemberGroup> groups = new ArrayList<MemberGroup>();
        Collection<MemberGroup> possibleInitialGroups = brokerGroup.getPossibleInitialGroups();
        if (CollectionUtils.isNotEmpty(possibleInitialGroups)) {
            for (MemberGroup memberGroup : possibleInitialGroups) {
                if (groups.contains(memberGroup)) continue;
                groups.add(memberGroup);
            }
        }
        request.setAttribute("groups", groups);
        BrokeringQuery query = this.getDataBinder().readFromString(form.getQuery());
        if (query.getStatus() == null) {
            query.setStatus(BrokeringQuery.Status.ACTIVE);
        }
        query.setBroker(broker);
        query.fetch(RelationshipHelper.nested(Brokering.Relationships.BROKERED, Element.Relationships.USER));
        request.setAttribute("broker", (Object)broker);
        request.setAttribute("myBrokerings", (Object)myBrokerings);
        request.setAttribute("canChangeBroker", (Object)canChangeBroker);
        request.setAttribute("status", this.brokeringService.listPossibleStatuses(brokerGroup));
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }
}

