/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.brokering.ManageBrokerCommissionsForm;
import nl.strohalm.cyclos.controls.members.brokering.SearchBrokerCommissionContractsAction;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFeeQuery;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContractQuery;
import nl.strohalm.cyclos.entities.members.brokerings.DefaultBrokerCommission;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.elements.CommissionService;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ManageBrokerCommissionsAction
extends BaseQueryAction
implements LocalSettingsChangeListener {
    private CommissionService commissionService;
    private TransactionFeeService transactionFeeService;
    private DataBinder<BrokerCommissionContractQuery> dataBinder;

    public DataBinder<BrokerCommissionContractQuery> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = SearchBrokerCommissionContractsAction.prepareQueryDataBinder(this.settingsService);
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setCommissionService(CommissionService commissionService) {
        this.commissionService = commissionService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        BrokerCommissionContractQuery query = (BrokerCommissionContractQuery)queryParameters;
        List<BrokerCommissionContract> brokerCommissioncontracts = this.commissionService.searchBrokerCommissionContracts(query);
        request.setAttribute("brokerCommissionContracts", brokerCommissioncontracts);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        ManageBrokerCommissionsForm form = (ManageBrokerCommissionsForm)((Object)context.getForm());
        long brokerId = form.getBrokerId();
        if (!context.isAdmin() || brokerId < 0L) {
            throw new ValidationException();
        }
        Member broker = (Member)this.elementService.load(brokerId, Element.Relationships.GROUP);
        BrokerGroup brokerGroup = (BrokerGroup)broker.getGroup();
        TransactionFeeQuery transactionFeeQuery = new TransactionFeeQuery();
        transactionFeeQuery.setEntityType(BrokerCommission.class);
        transactionFeeQuery.setGeneratedTransferTypeFromNature(AccountType.Nature.MEMBER);
        transactionFeeQuery.setBrokerGroup(brokerGroup);
        transactionFeeQuery.setReturnDisabled(true);
        List<? extends TransactionFee> brokerCommissions = this.transactionFeeService.search(transactionFeeQuery);
        List<DefaultBrokerCommission> defaultBrokerCommissions = this.commissionService.loadDefaultBrokerCommissions(broker, DefaultBrokerCommission.Relationships.BROKER_COMMISSION);
        request.setAttribute("broker", (Object)broker);
        request.setAttribute("brokerCommissions", brokerCommissions);
        request.setAttribute("defaultBrokerCommissions", defaultBrokerCommissions);
        RequestHelper.storeEnum(request, BrokerCommissionContract.Status.class, "statusList");
        BrokerCommissionContractQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setBroker(broker);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }
}

