/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import java.util.HashMap;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.brokering.ChangeBrokerAction;
import nl.strohalm.cyclos.controls.members.brokering.ChangeBrokerForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.elements.BrokeringService;
import nl.strohalm.cyclos.services.elements.ChangeBrokerDTO;
import nl.strohalm.cyclos.services.elements.exceptions.CircularBrokeringException;
import nl.strohalm.cyclos.services.elements.exceptions.MemberAlreadyInBrokeringsException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ManageBrokeredMemberAction
extends BaseFormAction {
    private DataBinder<ChangeBrokerDTO> dataBinder;
    private BrokeringService brokeringService;

    public BrokeringService getBrokeringService() {
        return this.brokeringService;
    }

    public DataBinder<ChangeBrokerDTO> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = ChangeBrokerAction.changeBrokerDTODataBinder();
        }
        return this.dataBinder;
    }

    @Inject
    public void setBrokeringService(BrokeringService brokeringService) {
        this.brokeringService = brokeringService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        ChangeBrokerForm form = (ChangeBrokerForm)((Object)context.getForm());
        ChangeBrokerDTO dto = this.getDataBinder().readFromString((Object)form);
        try {
            this.brokeringService.changeBroker(dto);
            context.sendMessage("changeBroker.changed", new Object[0]);
        }
        catch (MemberAlreadyInBrokeringsException e) {
            context.sendMessage("brokering.error.memberAlreadyInBrokering", new Object[0]);
        }
        catch (CircularBrokeringException e) {
            context.sendMessage("brokering.error.circularBrokering", new Object[0]);
        }
        long brokerId = form.getBrokerId();
        if (brokerId <= 0L) {
            brokerId = form.getNewBrokerId();
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "memberId", brokerId);
    }

    @Override
    protected ActionForward handleValidation(ActionContext context) {
        try {
            ChangeBrokerForm form = (ChangeBrokerForm)((Object)context.getForm());
            ChangeBrokerDTO dto = this.getDataBinder().readFromString((Object)form);
            this.brokeringService.validate(dto);
            Member member = (Member)this.elementService.load(dto.getMember().getId(), Member.Relationships.BROKER);
            HashMap<String, String> fields = new HashMap<String, String>();
            Member broker = member.getBroker();
            Member newBroker = dto.getNewBroker() == null ? null : this.elementService.load(dto.getNewBroker().getId(), new Relationship[0]);
            fields.put("currentBroker", broker == null ? "" : broker.getName());
            fields.put("newBroker", newBroker == null ? "" : newBroker.getName());
            fields.put("member", ((Element)this.elementService.load(dto.getMember().getId(), new Relationship[0])).getName());
            this.responseHelper.writeStatus(context.getResponse(), (Object)ResponseHelper.Status.SUCCESS, fields);
        }
        catch (ValidationException e) {
            this.responseHelper.writeValidationErrors(context.getResponse(), e);
        }
        return null;
    }
}

