/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.members.brokering.BrokeredIterator;
import nl.strohalm.cyclos.controls.members.brokering.ListBrokeringsAction;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.members.BrokeringQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.transactions.LoanService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class PrintBrokeringsAction
extends ListBrokeringsAction {
    private MemberCustomFieldService memberCustomFieldService;
    private LoanService loanService;

    public LoanService getLoanService() {
        return this.loanService;
    }

    public MemberCustomFieldService getMemberCustomFieldService() {
        return this.memberCustomFieldService;
    }

    @Inject
    public void setLoanService(LoanService loanService) {
        this.loanService = loanService;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        queryParameters.setResultType(QueryParameters.ResultType.LIST);
        super.executeQuery(context, queryParameters);
        HttpServletRequest request = context.getRequest();
        BrokeringQuery query = (BrokeringQuery)queryParameters;
        boolean showLoanData = false;
        if (query.getStatus() != BrokeringQuery.Status.PENDING) {
            showLoanData = context.isAdmin() ? this.permissionService.hasPermission(AdminMemberPermission.BROKERINGS_VIEW_LOANS) : this.permissionService.hasPermission(BrokerPermission.LOANS_VIEW);
        }
        List brokerings = (List)request.getAttribute("brokerings");
        request.setAttribute("brokerings", (Object)new BrokeredIterator(brokerings.iterator(), this.loanService, showLoanData));
        request.setAttribute("showLoanData", (Object)showLoanData);
    }

    @Override
    protected Integer pageSize(ActionContext context) {
        return null;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        BrokeringQuery query = (BrokeringQuery)super.prepareForm(context);
        query.fetch(RelationshipHelper.nested(Brokering.Relationships.BROKERED, Element.Relationships.GROUP), RelationshipHelper.nested(Brokering.Relationships.BROKERED, Member.Relationships.CUSTOM_VALUES));
        LinkedList customFields = new LinkedList(this.memberCustomFieldService.list());
        Iterator it = customFields.iterator();
        while (it.hasNext()) {
            MemberCustomField field = (MemberCustomField)it.next();
            if (!field.isShowInPrint()) {
                it.remove();
                continue;
            }
            MemberCustomField.Access access = field.getVisibilityAccess();
            if (access == null || access.grantedToBroker()) continue;
            it.remove();
        }
        request.setAttribute("memberFields", customFields);
        return query;
    }
}

