/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.brokering.SearchBrokerCommissionContractsForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFeeQuery;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContractQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.elements.CommissionService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class SearchBrokerCommissionContractsAction
extends BaseQueryAction {
    private CommissionService commissionService;
    private TransactionFeeService transactionFeeService;
    private DataBinder<BrokerCommissionContractQuery> dataBinder;

    public static DataBinder<BrokerCommissionContractQuery> prepareQueryDataBinder(SettingsService settingsService) {
        LocalSettings localSettings = settingsService.getLocalSettings();
        BeanBinder<BrokerCommissionContractQuery> binder = BeanBinder.instance(BrokerCommissionContractQuery.class);
        binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
        binder.registerBinder("brokerCommission", PropertyBinder.instance(BrokerCommission.class, "brokerCommission"));
        binder.registerBinder("startPeriod", DataBinderHelper.periodBinder(localSettings, "startPeriod"));
        binder.registerBinder("endPeriod", DataBinderHelper.periodBinder(localSettings, "endPeriod"));
        binder.registerBinder("status", PropertyBinder.instance(BrokerCommissionContract.Status.class, "status"));
        return binder;
    }

    @Inject
    public void setCommissionService(CommissionService commissionService) {
        this.commissionService = commissionService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        BrokerCommissionContractQuery query = (BrokerCommissionContractQuery)queryParameters;
        List<BrokerCommissionContract> brokerCommissionContracts = this.commissionService.searchBrokerCommissionContracts(query);
        context.getRequest().setAttribute("brokerCommissionContracts", brokerCommissionContracts);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        if (!context.isBroker()) {
            throw new ValidationException();
        }
        HttpServletRequest request = context.getRequest();
        SearchBrokerCommissionContractsForm form = (SearchBrokerCommissionContractsForm)((Object)context.getForm());
        Member broker = (Member)context.getElement();
        BrokerGroup brokerGroup = (BrokerGroup)context.getGroup();
        TransactionFeeQuery transactionFeeQuery = new TransactionFeeQuery();
        transactionFeeQuery.setGeneratedTransferTypeFromNature(AccountType.Nature.MEMBER);
        transactionFeeQuery.setEntityType(BrokerCommission.class);
        transactionFeeQuery.setBrokerGroup(brokerGroup);
        List<? extends TransactionFee> brokerCommissions = this.transactionFeeService.search(transactionFeeQuery);
        request.setAttribute("brokerCommissions", brokerCommissions);
        RequestHelper.storeEnum(request, BrokerCommissionContract.Status.class, "statusList");
        BrokerCommissionContractQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setBroker(broker);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<BrokerCommissionContractQuery> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = SearchBrokerCommissionContractsAction.prepareQueryDataBinder(this.settingsService);
        }
        return this.dataBinder;
    }
}

