/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.brokering;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.members.brokering.UnsuspendBrokerCommissionForm;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.elements.CommissionService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class UnsuspendBrokerCommissionAction
extends BaseAction {
    private CommissionService commissionService;

    @Inject
    public void setCommissionService(CommissionService commissionService) {
        this.commissionService = commissionService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        UnsuspendBrokerCommissionForm form = (UnsuspendBrokerCommissionForm)((Object)context.getForm());
        long brokerCommissionId = form.getBrokerCommissionId();
        long brokerId = form.getBrokerId();
        if (brokerCommissionId < 1L || brokerId < 1L) {
            throw new ValidationException();
        }
        BrokerCommission brokerCommission = EntityHelper.reference(BrokerCommission.class, brokerCommissionId);
        Member broker = EntityHelper.reference(Member.class, brokerId);
        try {
            this.commissionService.unsuspendCommissions(brokerCommission, broker);
            context.sendMessage("brokerCommission.unsuspended", new Object[0]);
        }
        catch (Exception e) {
            context.sendMessage("brokerCommission.error.unsuspending", new Object[0]);
        }
        return ActionHelper.redirectWithParam(request, context.getSuccessForward(), "brokerId", brokerId);
    }
}

