/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.bulk;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.members.SearchMembersAction;
import nl.strohalm.cyclos.controls.members.bulk.MemberBulkChangeChannelsAction;
import nl.strohalm.cyclos.controls.members.bulk.MemberBulkChangeGroupAction;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class MemberBulkActionsAction
extends SearchMembersAction {
    private ChannelService channelService;

    @Inject
    public final void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Override
    protected boolean allowRemovedGroups() {
        return false;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        FullTextMemberQuery memberQuery = (FullTextMemberQuery)super.prepareForm(context);
        memberQuery.setEnabled(true);
        HttpServletRequest request = context.getRequest();
        List<MemberCustomField> fields = this.customFieldHelper.onlyForMemberSearch(this.memberCustomFieldService.list());
        request.setAttribute("customFields", this.customFieldHelper.buildEntries(fields, memberQuery.getCustomValues()));
        MemberBulkChangeGroupAction.prepare(context, this.groupService);
        if (this.permissionService.hasPermission(AdminMemberPermission.BULK_ACTIONS_CHANGE_CHANNELS)) {
            MemberBulkChangeChannelsAction.prepare(context, this.channelService);
        }
        return memberQuery;
    }
}

