/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.bulk;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.SearchMembersAction;
import nl.strohalm.cyclos.controls.members.bulk.MemberBulkActionsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.elements.BrokeringService;
import nl.strohalm.cyclos.services.elements.BulkMemberActionResultVO;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.MapBean;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MemberBulkChangeBrokerAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private BrokeringService brokeringService;
    private DataBinder<FullTextMemberQuery> dataBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<FullTextMemberQuery> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                this.dataBinder = SearchMembersAction.memberQueryDataBinder(localSettings);
            }
            DataBinder<FullTextMemberQuery> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setBrokeringService(BrokeringService brokeringService) {
        this.brokeringService = brokeringService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        MemberBulkActionsForm form = (MemberBulkActionsForm)((Object)context.getForm());
        MapBean bean = form.getChangeBroker();
        FullTextMemberQuery query = this.getDataBinder().readFromString(form.getQuery());
        Member newBroker = (Member)this.elementService.load(CoercionHelper.coerce(Long.class, bean.get("newBroker")), new Relationship[0]);
        boolean suspendCommission = CoercionHelper.coerce(Boolean.TYPE, bean.get("suspendCommission"));
        String comments = StringUtils.trimToNull((String)((String)bean.get("comments")));
        BulkMemberActionResultVO results = this.brokeringService.bulkChangeMemberBroker(query, newBroker, suspendCommission, comments);
        context.sendMessage("member.bulkActions.brokerChanged", results.getChanged(), results.getUnchanged(), newBroker.getName());
        form.getChangeBroker().clear();
    }

    @Override
    protected void validateForm(ActionContext context) {
        MemberBulkActionsForm form = (MemberBulkActionsForm)((Object)context.getForm());
        FullTextMemberQuery query = this.getDataBinder().readFromString(form.getQuery());
        Collection<? extends CustomFieldValue> customValues = query.getCustomValues();
        Iterator<? extends CustomFieldValue> it = customValues.iterator();
        while (it.hasNext()) {
            MemberCustomFieldValue fieldValue = (MemberCustomFieldValue)it.next();
            if (!StringUtils.isEmpty((String)fieldValue.getValue())) continue;
            it.remove();
        }
        if (CollectionUtils.isEmpty(query.getGroupFilters()) && CollectionUtils.isEmpty(query.getGroups()) && query.getBroker() == null && CollectionUtils.isEmpty(customValues)) {
            throw new ValidationException("member.bulkActions.error.emptyQuery", new Object[0]);
        }
        MapBean bean = form.getChangeBroker();
        Member newBroker = CoercionHelper.coerce(Member.class, bean.get("newBroker"));
        String comments = StringUtils.trimToNull((String)((String)bean.get("comments")));
        if (newBroker == null || newBroker.isTransient()) {
            throw new ValidationException("newBroker", "changeBroker.new", new RequiredError(new Object[0]));
        }
        if (StringUtils.isEmpty((String)comments)) {
            throw new ValidationException("comments", "remark.comments", new RequiredError(new Object[0]));
        }
    }
}

