/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.bulk;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.SearchMembersAction;
import nl.strohalm.cyclos.controls.members.bulk.MemberBulkActionsForm;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.elements.BulkMemberActionResultVO;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;

public class MemberBulkChangeChannelsAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private DataBinder<FullTextMemberQuery> dataBinder;
    private BeanBinder<ChangeChannelsBean> beanBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);
    protected ChannelService channelService;

    static void prepare(ActionContext context, ChannelService channelService) {
        HttpServletRequest request = context.getRequest();
        List<Channel> channels = channelService.list();
        Channel webChannel = channelService.loadByInternalName("web");
        channels.remove(webChannel);
        request.setAttribute("channels", channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<FullTextMemberQuery> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                this.dataBinder = SearchMembersAction.memberQueryDataBinder(localSettings);
            }
            DataBinder<FullTextMemberQuery> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public final void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        MemberBulkActionsForm form = (MemberBulkActionsForm)((Object)context.getForm());
        ChangeChannelsBean changeChanelsBean = this.getBeanBinder().readFromString(form.getChangeChannels());
        FullTextMemberQuery query = this.getDataBinder().readFromString(form.getQuery());
        BulkMemberActionResultVO result = this.elementService.bulkChangeMemberChannels(query, changeChanelsBean.enableChannels, changeChanelsBean.disableChannels);
        if (result.getChanged() > 0 && result.getUnchanged() > 0) {
            context.sendMessage("member.bulkActions.channelsChanged", result.getChanged(), result.getUnchanged());
        } else if (result.getChanged() > 0) {
            context.sendMessage("member.bulkActions.channelsChangedForAll", result.getChanged());
        } else {
            context.sendMessage("member.bulkActions.channelsNotChanged", result.getUnchanged());
        }
        form.getChangeChannels().clear();
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        MemberBulkChangeChannelsAction.prepare(context, this.channelService);
    }

    @Override
    protected void validateForm(ActionContext context) {
        MemberBulkActionsForm form = (MemberBulkActionsForm)((Object)context.getForm());
        ChangeChannelsBean changeChanelsBean = this.getBeanBinder().readFromString(form.getChangeChannels());
        FullTextMemberQuery query = this.getDataBinder().readFromString(form.getQuery());
        this.elementService.validateBulkChangeChannels(query, changeChanelsBean.enableChannels, changeChanelsBean.disableChannels);
    }

    private BeanBinder<ChangeChannelsBean> getBeanBinder() {
        if (this.beanBinder != null) {
            return this.beanBinder;
        }
        BeanBinder<ChangeChannelsBean> beanBinder = BeanBinder.instance(ChangeChannelsBean.class);
        beanBinder.registerBinder("enableChannels", SimpleCollectionBinder.instance(Channel.class, HashSet.class, "enableIds"));
        beanBinder.registerBinder("disableChannels", SimpleCollectionBinder.instance(Channel.class, HashSet.class, "disableIds"));
        return beanBinder;
    }

    public static class ChangeChannelsBean {
        Collection<Channel> enableChannels;
        Collection<Channel> disableChannels;

        public Collection<Channel> getDisableChannels() {
            return this.disableChannels;
        }

        public Collection<Channel> getEnableChannels() {
            return this.enableChannels;
        }

        public void setDisableChannels(Collection<Channel> disabledChannels) {
            this.disableChannels = disabledChannels;
        }

        public void setEnableChannels(Collection<Channel> enabledChannels) {
            this.enableChannels = enabledChannels;
        }
    }
}

