/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.bulk;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.SearchMembersAction;
import nl.strohalm.cyclos.controls.members.bulk.MemberBulkActionsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.elements.BulkMemberActionResultVO;
import nl.strohalm.cyclos.services.groups.GroupService;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.MapBean;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MemberBulkChangeGroupAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private DataBinder<FullTextMemberQuery> dataBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    static void prepare(ActionContext context, GroupService groupService) {
        HttpServletRequest request = context.getRequest();
        GroupQuery query = new GroupQuery();
        query.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
        query.setStatus(Group.Status.NORMAL);
        request.setAttribute("possibleNewGroups", groupService.search(query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBinder<FullTextMemberQuery> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                this.dataBinder = SearchMembersAction.memberQueryDataBinder(localSettings);
            }
            DataBinder<FullTextMemberQuery> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        MemberBulkActionsForm form = (MemberBulkActionsForm)((Object)context.getForm());
        MapBean bean = form.getChangeGroup();
        FullTextMemberQuery query = this.getDataBinder().readFromString(form.getQuery());
        MemberGroup newGroup = (MemberGroup)this.groupService.load(CoercionHelper.coerce(Long.class, bean.get("newGroup")), new Relationship[0]);
        String comments = StringUtils.trimToNull((String)((String)bean.get("comments")));
        BulkMemberActionResultVO results = this.elementService.bulkChangeMemberGroup(query, newGroup, comments);
        context.sendMessage("member.bulkActions.groupChanged", results.getChanged(), results.getUnchanged(), newGroup.getName());
        form.getChangeGroup().clear();
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        MemberBulkChangeGroupAction.prepare(context, this.groupService);
    }

    @Override
    protected void validateForm(ActionContext context) {
        MemberBulkActionsForm form = (MemberBulkActionsForm)((Object)context.getForm());
        FullTextMemberQuery query = this.getDataBinder().readFromString(form.getQuery());
        Collection<? extends CustomFieldValue> customValues = query.getCustomValues();
        Iterator<? extends CustomFieldValue> it = customValues.iterator();
        while (it.hasNext()) {
            MemberCustomFieldValue fieldValue = (MemberCustomFieldValue)it.next();
            if (!StringUtils.isEmpty((String)fieldValue.getValue())) continue;
            it.remove();
        }
        if (CollectionUtils.isEmpty(query.getGroupFilters()) && CollectionUtils.isEmpty(query.getGroups()) && query.getBroker() == null && CollectionUtils.isEmpty(customValues)) {
            throw new ValidationException("member.bulkActions.error.emptyQuery", new Object[0]);
        }
        MapBean bean = form.getChangeGroup();
        MemberGroup newGroup = CoercionHelper.coerce(MemberGroup.class, bean.get("newGroup"));
        String comments = StringUtils.trimToNull((String)((String)bean.get("comments")));
        if (newGroup == null || newGroup.isTransient()) {
            throw new ValidationException("newGroup", "changeGroup.new", new RequiredError(new Object[0]));
        }
        if (StringUtils.isEmpty((String)comments)) {
            throw new ValidationException("comments", "remark.comments", new RequiredError(new Object[0]));
        }
    }
}

