/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.contacts;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.members.contacts.AddContactForm;
import nl.strohalm.cyclos.entities.members.Contact;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.elements.ContactService;
import nl.strohalm.cyclos.services.elements.exceptions.ContactAlreadyExistException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class AddContactAction
extends BaseAction {
    private ContactService contactService;
    private ResponseHelper responseHelper;

    public ContactService getContactService() {
        return this.contactService;
    }

    @Inject
    public void setContactService(ContactService contactService) {
        this.contactService = contactService;
    }

    @Inject
    public void setResponseHelper(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        AddContactForm form = (AddContactForm)((Object)context.getForm());
        long memberId = form.getMemberId();
        if (RequestHelper.isValidation(context.getRequest())) {
            try {
                if (memberId <= 0L) {
                    throw new ValidationException("contact", "member.member", new RequiredError(new Object[0]));
                }
                this.responseHelper.writeValidationSuccess(context.getResponse());
            }
            catch (ValidationException e) {
                this.responseHelper.writeValidationErrors(context.getResponse(), e);
            }
            return null;
        }
        if (memberId <= 0L) {
            throw new ValidationException();
        }
        Contact contact = new Contact();
        Member member = (Member)context.getAccountOwner();
        contact.setOwner(member);
        contact.setContact(EntityHelper.reference(Member.class, memberId));
        try {
            this.contactService.save(contact);
            context.sendMessage("contact.inserted", new Object[0]);
        }
        catch (ContactAlreadyExistException e) {
            context.sendMessage("contact.error.alreadyExists", new Object[0]);
        }
        if (form.isDirect()) {
            return context.findForward("backToList");
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.findForward("backToProfile"), "memberId", memberId);
    }
}

