/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.contacts;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.contacts.ContactForm;
import nl.strohalm.cyclos.entities.members.Contact;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.elements.ContactService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;

public class EditContactAction
extends BaseFormAction {
    private ContactService contactService;
    private DataBinder<Contact> dataBinder;

    public ContactService getContactService() {
        return this.contactService;
    }

    public DataBinder<Contact> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<Contact> binder = BeanBinder.instance(Contact.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("contact", PropertyBinder.instance(Member.class, "contact", ReferenceConverter.instance(Member.class)));
            binder.registerBinder("owner", PropertyBinder.instance(Member.class, "owner", ReferenceConverter.instance(Member.class)));
            binder.registerBinder("notes", PropertyBinder.instance(String.class, "notes"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setContactService(ContactService memberService) {
        this.contactService = memberService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        ContactForm form = (ContactForm)((Object)context.getForm());
        Contact contact = this.dataBinder.readFromString(form.getContact());
        this.contactService.save(contact);
        context.sendMessage("contact.modified", new Object[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        ContactForm form = (ContactForm)((Object)context.getForm());
        Contact contact = this.contactService.load(form.getId(), RelationshipHelper.nested(Contact.Relationships.CONTACT, Element.Relationships.USER));
        this.getDataBinder().writeAsString(form.getContact(), contact);
        context.getRequest().setAttribute("contact", (Object)contact.getContact());
    }

    @Override
    protected void validateForm(ActionContext context) {
        ContactForm form = (ContactForm)((Object)context.getForm());
        Contact contact = this.dataBinder.readFromString(form.getContact());
        this.contactService.validate(contact);
    }
}

