/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.creditlimit;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.creditlimit.EditCreditLimitForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.CreditLimitDTO;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.MapBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditCreditLimitAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private AccountService accountService;
    private DataBinder<CreditLimitDTO> dataBinder;

    public AccountService getAccountService() {
        return this.accountService;
    }

    public DataBinder<CreditLimitDTO> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            PropertyBinder<AccountType> keyBinder = PropertyBinder.instance(AccountType.class, "accountTypeIds");
            PropertyBinder<BigDecimal> limitValueBinder = PropertyBinder.instance(BigDecimal.class, "newCreditLimits", localSettings.getNumberConverter().negativeToAbsolute());
            PropertyBinder<BigDecimal> upperLimitValueBinder = PropertyBinder.instance(BigDecimal.class, "newUpperCreditLimits", localSettings.getNumberConverter());
            MapBinder<AccountType, BigDecimal> limitBinder = MapBinder.instance(keyBinder, limitValueBinder);
            MapBinder<AccountType, BigDecimal> upperLimitBinder = MapBinder.instance(keyBinder, upperLimitValueBinder);
            BeanBinder<CreditLimitDTO> binder = BeanBinder.instance(CreditLimitDTO.class);
            binder.registerBinder("limitPerType", limitBinder);
            binder.registerBinder("upperLimitPerType", upperLimitBinder);
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditCreditLimitForm form = (EditCreditLimitForm)((Object)context.getForm());
        CreditLimitDTO creditLimit = this.getDataBinder().readFromString((Object)form);
        this.accountService.setCreditLimit(this.getMember(form), creditLimit);
        context.sendMessage("creditLimit.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "memberId", form.getMemberId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditCreditLimitForm form = (EditCreditLimitForm)((Object)context.getForm());
        long id = form.getMemberId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        Member member = (Member)this.elementService.load(id, Element.Relationships.USER);
        CreditLimitDTO creditLimit = this.accountService.getCreditLimits(member);
        Map<? extends AccountType, BigDecimal> limitPerType = creditLimit.getLimitPerType();
        HashMap<? extends AccountType, BigDecimal> newLimitPerType = new HashMap<AccountType, BigDecimal>();
        for (AccountType accountType : limitPerType.keySet()) {
            BigDecimal limit = limitPerType.get(accountType);
            if (limit != null && limit.compareTo(new BigDecimal(0)) == 1) {
                limit = limit.negate();
            }
            newLimitPerType.put(accountType, limit);
        }
        limitPerType = newLimitPerType;
        creditLimit.setLimitPerType(limitPerType);
        request.setAttribute("member", (Object)member);
        request.setAttribute("limits", creditLimit.getEntries());
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditCreditLimitForm form = (EditCreditLimitForm)((Object)context.getForm());
        CreditLimitDTO creditLimit = this.getDataBinder().readFromString((Object)form);
        this.accountService.validate(this.getMember(form), creditLimit);
    }

    private Member getMember(EditCreditLimitForm form) {
        return EntityHelper.reference(Member.class, form.getMemberId());
    }
}

