/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.documents;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.members.documents.SelectDocumentForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.customization.documents.DocumentQuery;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.customization.DocumentService;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class SelectDocumentAction
extends BaseAction {
    private DocumentService documentService;

    @Inject
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        Member member;
        boolean byBroker;
        boolean brokerCanManage;
        boolean adminCanManage;
        boolean myDocuments;
        HttpServletRequest request;
        block7: {
            request = context.getRequest();
            SelectDocumentForm form = (SelectDocumentForm)((Object)context.getForm());
            myDocuments = false;
            adminCanManage = false;
            brokerCanManage = false;
            byBroker = false;
            long memberId = form.getMemberId();
            member = null;
            if (memberId > 0L) {
                try {
                    member = (Member)this.elementService.load(memberId, Element.Relationships.USER);
                    if (memberId == ((Entity)context.getElement()).getId()) {
                        myDocuments = true;
                        break block7;
                    }
                    byBroker = context.isBrokerOf(member);
                    adminCanManage = this.permissionService.hasPermission(AdminMemberPermission.DOCUMENTS_MANAGE_MEMBER);
                    brokerCanManage = this.permissionService.hasPermission(BrokerPermission.DOCUMENTS_MANAGE_MEMBER);
                }
                catch (Exception e) {}
            } else {
                if (context.isAdmin() || context.isOperator()) {
                    throw new ValidationException();
                }
                member = (Member)context.getElement();
                memberId = member.getId();
                myDocuments = true;
            }
        }
        if (member == null) {
            throw new ValidationException();
        }
        DocumentQuery documentQuery = new DocumentQuery();
        documentQuery.setMember(member);
        List<Document> documents = this.documentService.search(documentQuery);
        request.setAttribute("member", (Object)member);
        request.setAttribute("documents", documents);
        request.setAttribute("myDocuments", (Object)myDocuments);
        request.setAttribute("byBroker", (Object)byBroker);
        request.setAttribute("adminCanManage", (Object)adminCanManage);
        request.setAttribute("brokerCanManage", (Object)brokerCanManage);
        request.setAttribute("removed", (Object)(member.getGroup().getStatus() == Group.Status.REMOVED ? 1 : 0));
        return context.getInputForward();
    }
}

