/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.imports;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.imports.ImportMembersForm;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.imports.MemberImport;
import nl.strohalm.cyclos.services.elements.MemberImportService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.csv.UnknownColumnException;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;

public class ImportMembersAction
extends BaseFormAction {
    private MemberImportService memberImportService;
    private DataBinder<MemberImport> dataBinder;

    @Inject
    public void setMemberImportService(MemberImportService memberImportService) {
        this.memberImportService = memberImportService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        ImportMembersForm form = (ImportMembersForm)((Object)context.getForm());
        FormFile upload = form.getUpload();
        if (upload == null || upload.getFileSize() == 0) {
            throw new ValidationException("upload", "memberImport.file", new RequiredError(new Object[0]));
        }
        MemberImport memberImport = this.getDataBinder().readFromString(form.getImport());
        try {
            memberImport = this.memberImportService.importMembers(memberImport, upload.getInputStream());
            ActionForward actionForward = ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "importId", memberImport.getId());
            return actionForward;
        }
        catch (UnknownColumnException e) {
            ActionForward actionForward = context.sendError("general.error.csv.unknownColumn", e.getColumn());
            return actionForward;
        }
        finally {
            upload.destroy();
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        GroupQuery groupQuery = new GroupQuery();
        groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
        groupQuery.setManagedBy((AdminGroup)context.getGroup());
        groupQuery.setStatus(Group.Status.NORMAL);
        List<? extends Group> groups = this.groupService.search(groupQuery);
        request.setAttribute("groups", groups);
    }

    @Override
    protected void validateForm(ActionContext context) {
        ImportMembersForm form = (ImportMembersForm)((Object)context.getForm());
        MemberImport memberImport = this.getDataBinder().readFromString(form.getImport());
        this.memberImportService.validate(memberImport);
    }

    private DataBinder<MemberImport> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<MemberImport> binder = BeanBinder.instance(MemberImport.class);
            binder.registerBinder("group", PropertyBinder.instance(MemberGroup.class, "group"));
            binder.registerBinder("accountType", PropertyBinder.instance(MemberAccountType.class, "accountType"));
            binder.registerBinder("initialDebitTransferType", PropertyBinder.instance(TransferType.class, "initialDebitTransferType"));
            binder.registerBinder("initialCreditTransferType", PropertyBinder.instance(TransferType.class, "initialCreditTransferType"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

