/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.imports;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.imports.ImportedMembersDetailsForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.members.imports.ImportedMember;
import nl.strohalm.cyclos.entities.members.imports.ImportedMemberQuery;
import nl.strohalm.cyclos.entities.members.imports.MemberImport;
import nl.strohalm.cyclos.services.elements.MemberImportService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ImportedMembersDetailsAction
extends BaseQueryAction {
    private MemberImportService memberImportService;
    private DataBinder<ImportedMemberQuery> dataBinder;

    public DataBinder<ImportedMemberQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<ImportedMemberQuery> binder = BeanBinder.instance(ImportedMemberQuery.class);
            binder.registerBinder("memberImport", PropertyBinder.instance(MemberImport.class, "memberImport"));
            binder.registerBinder("status", PropertyBinder.instance(ImportedMemberQuery.Status.class, "status"));
            binder.registerBinder("lineNumber", PropertyBinder.instance(Integer.class, "lineNumber"));
            binder.registerBinder("nameOrUsername", PropertyBinder.instance(String.class, "nameOrUsername"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setMemberImportService(MemberImportService memberImportService) {
        this.memberImportService = memberImportService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        ImportedMemberQuery query = (ImportedMemberQuery)queryParameters;
        List<ImportedMember> members = this.memberImportService.searchImportedMembers(query);
        request.setAttribute("importedMembers", members);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        ImportedMembersDetailsForm form = (ImportedMembersDetailsForm)((Object)context.getForm());
        ImportedMemberQuery query = this.getDataBinder().readFromString(form.getQuery());
        MemberImport memberImport = this.memberImportService.load(query.getMemberImport().getId(), RelationshipHelper.nested(MemberImport.Relationships.ACCOUNT_TYPE, AccountType.Relationships.CURRENCY));
        if (memberImport == null || query.getStatus() == null) {
            throw new ValidationException();
        }
        query.setMemberImport(memberImport);
        MemberAccountType accountType = memberImport.getAccountType();
        if (accountType != null) {
            request.setAttribute("unitsPattern", (Object)accountType.getCurrency().getPattern());
            request.setAttribute("hasCreditLimit", (Object)true);
            if (memberImport.getInitialCreditTransferType() != null || memberImport.getInitialDebitTransferType() != null) {
                request.setAttribute("hasBalance", (Object)true);
            }
        }
        request.setAttribute("lowercaseStatus", (Object)query.getStatus().name().toLowerCase());
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }
}

