/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.imports;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.imports.ImportedMembersSummaryForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.members.imports.MemberImport;
import nl.strohalm.cyclos.services.elements.MemberImportService;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ImportedMembersSummaryAction
extends BaseFormAction {
    private MemberImportService memberImportService;

    @Inject
    public void setMemberImportService(MemberImportService memberImportService) {
        this.memberImportService = memberImportService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        ImportedMembersSummaryForm form = (ImportedMembersSummaryForm)((Object)context.getForm());
        MemberImport memberImport = this.getImport(context);
        try {
            this.memberImportService.processImport(memberImport, form.isSendActivationMail());
        }
        catch (CreditsException e) {
            throw new ValidationException(this.actionHelper.resolveErrorKey(e), this.actionHelper.resolveParameters(e));
        }
        context.sendMessage("memberImport.processed", new Object[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        MemberImport memberImport = this.getImport(context);
        HttpServletRequest request = context.getRequest();
        request.setAttribute("memberImport", (Object)memberImport);
        request.setAttribute("summary", (Object)this.memberImportService.getSummary(memberImport));
    }

    private MemberImport getImport(ActionContext context) {
        ImportedMembersSummaryForm form = (ImportedMembersSummaryForm)((Object)context.getForm());
        return this.memberImportService.load(form.getImportId(), MemberImport.Relationships.GROUP, RelationshipHelper.nested(MemberImport.Relationships.ACCOUNT_TYPE, AccountType.Relationships.CURRENCY), MemberImport.Relationships.INITIAL_CREDIT_TRANSFER_TYPE, MemberImport.Relationships.INITIAL_DEBIT_TRANSFER_TYPE);
    }
}

