/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.loangroups;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.members.loangroups.MemberLoanGroupsForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroupQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.loangroups.LoanGroupService;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class MemberLoanGroupsAction
extends BaseAction {
    private LoanGroupService loanGroupService;

    public LoanGroupService getLoanGroupService() {
        return this.loanGroupService;
    }

    @Inject
    public void setLoanGroupService(LoanGroupService loanGroupService) {
        this.loanGroupService = loanGroupService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        LoanGroupQuery query;
        HttpServletRequest request = context.getRequest();
        MemberLoanGroupsForm form = (MemberLoanGroupsForm)((Object)context.getForm());
        long id = form.getMemberId();
        boolean myLoanGroups = false;
        boolean byBroker = false;
        boolean editable = false;
        Member member = null;
        Object loggedElement = context.getElement();
        if (id <= 0L || ((Entity)loggedElement).getId().equals(id)) {
            if (context.isMember()) {
                member = (Member)context.getElement();
                myLoanGroups = true;
            }
        } else {
            try {
                member = (Member)this.elementService.load(id, Element.Relationships.USER);
                if (context.isMember()) {
                    if (!context.isBrokerOf(member)) {
                        throw new PermissionDeniedException();
                    }
                    byBroker = true;
                } else {
                    editable = this.permissionService.hasPermission(AdminMemberPermission.LOAN_GROUPS_MANAGE);
                }
            }
            catch (PermissionDeniedException e) {
                throw e;
            }
            catch (Exception e) {
                member = null;
            }
        }
        if (member == null) {
            throw new ValidationException();
        }
        if (editable) {
            query = new LoanGroupQuery();
            query.setMember(member);
            query.setNotOfMember(true);
            request.setAttribute("unrelatedLoanGroups", this.loanGroupService.search(query));
        }
        query = new LoanGroupQuery();
        query.setMember(member);
        request.setAttribute("loanGroups", this.loanGroupService.search(query));
        request.setAttribute("member", (Object)member);
        request.setAttribute("myLoanGroups", (Object)myLoanGroups);
        request.setAttribute("byBroker", (Object)byBroker);
        request.setAttribute("editable", (Object)editable);
        return context.getInputForward();
    }
}

