/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.messages;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.messages.EditMessageCategoryForm;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.services.elements.MessageCategoryService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;

public class EditMessageCategoryAction
extends BaseFormAction {
    private MessageCategoryService messageCategoryService;
    private DataBinder<MessageCategory> dataBinder;

    public DataBinder<MessageCategory> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<MessageCategory> binder = BeanBinder.instance(MessageCategory.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public MessageCategoryService getMessageCategoryService() {
        return this.messageCategoryService;
    }

    @Inject
    public void setMessageCategoryService(MessageCategoryService messageCategoryService) {
        this.messageCategoryService = messageCategoryService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        EditMessageCategoryForm form = (EditMessageCategoryForm)((Object)context.getForm());
        MessageCategory category = this.getDataBinder().readFromString(form.getMessageCategory());
        boolean insert = category.getId() == null;
        this.messageCategoryService.save(category);
        context.sendMessage(insert ? "messageCategory.inserted" : "messageCategory.modified", new Object[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        EditMessageCategoryForm form = (EditMessageCategoryForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        MessageCategory messageCategory = form.getMessageCategoryId() > 0L ? this.messageCategoryService.load(form.getMessageCategoryId()) : new MessageCategory();
        this.getDataBinder().writeAsString(form.getMessageCategory(), messageCategory);
        request.setAttribute("messageCategory", (Object)messageCategory);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditMessageCategoryForm form = (EditMessageCategoryForm)((Object)context.getForm());
        MessageCategory messageCategory = this.getDataBinder().readFromString(form.getMessageCategory());
        this.getMessageCategoryService().validate(messageCategory);
    }
}

