/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.messages;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.members.messages.RemoveMessageCategoryForm;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.services.elements.MessageCategoryService;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;
import org.springframework.dao.DataIntegrityViolationException;

public class RemoveMessageCategoryAction
extends BaseAction {
    private MessageCategoryService messageCategoryService;

    public MessageCategoryService getMessageCategoryService() {
        return this.messageCategoryService;
    }

    @Inject
    public void setMessageCategoryService(MessageCategoryService messageCategoryService) {
        this.messageCategoryService = messageCategoryService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        RemoveMessageCategoryForm form = (RemoveMessageCategoryForm)((Object)context.getForm());
        long id = form.getMessageCategoryId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        try {
            this.messageCategoryService.remove(id);
            context.sendMessage("messageCategory.removed", new Object[0]);
        }
        catch (DaoException e) {
            context.sendMessage("messageCategory.error.removing", new Object[0]);
        }
        catch (DataIntegrityViolationException e) {
            context.sendMessage("messageCategory.error.removing", new Object[0]);
        }
        return context.getSuccessForward();
    }
}

